const { dbQuery } = require("../../../config/db.config");
const { SC_ASC_ARTICLES } = require("../../../models/tables");
const { getArticlesService } = require("../../../services/article.service");
const tryCatch = require("../../../utils/tryCatch");

const scAscArticles = SC_ASC_ARTICLES;

//@desc getting articles for landing page only 4 articles by priority
//@route GET /api/v1/public/landing-page/articles
//@access PUBLIC
const getArticles = tryCatch(async (req, res) => {
  const queryMap = {}
  queryMap.attributes = [
    `${scAscArticles}.nr_id`,
    `${scAscArticles}.nr_title AS title`,
    `${scAscArticles}.nr_description AS breif_description`,
    `${scAscArticles}.nr_image AS image`,
    `${scAscArticles}.nr_front_url AS url`,
  ];
  queryMap.conditions = [`${scAscArticles}.nr_active = 'Y'`];
  queryMap.additional = [`ORDER BY ${scAscArticles}.nr_priority ASC LIMIT 4`];

  const result = await getArticlesService(queryMap);

  return res.status(200).json({
    status: "success",
    message: "Articles fetched successfully",
    data: result,
  });
});

module.exports = {getArticles};