const { C_INSTITUTE, C_COURSE, C_CONTACT, STATE_TBL, CITY_TBL } = require("../../../models/tables");
const { getCollegeService } = require("../../../services/college.service");
const tryCatch = require("../../../utils/tryCatch");

//@desc getting recommended colleges based on courses like management, engineering, etc
//@route GET /api/v1/public/landing-page/recommended-colleges/:course
//@access PUBLIC
const getRecommendedCollegesLandingPage = tryCatch(async (req, res) => {
  const { course } = req.params;
  if (!course) {
    return res.status(400).json({
      status: "fail",
      message: "No course provided",
      data: [],
    });
  }

  // sanitize course, remove special character of - only
  const sanitizedCourse = course.replace(/[^a-zA-Z0-9-]/g, " ");

  const queryMap = {
    attributes: [
      `${C_INSTITUTE}.e_id`,
      `${C_INSTITUTE}.institute_logo AS logo`,
      `${C_INSTITUTE}.institute_name AS name`,
      `${C_INSTITUTE}.institute_url AS url`,
      `${STATE_TBL}.state AS state`,
      `${CITY_TBL}.cname AS city`,
    ],
    conditions: [
      `${C_INSTITUTE}.top_college = 'Y'`,
      `${C_COURSE}.course_category IS NOT NULL`,
      `${C_INSTITUTE}.show_on_home = 'Y'`,
    ],
    additional: [
      `GROUP BY ${C_INSTITUTE}.e_id`,
      `ORDER BY ${C_INSTITUTE}.priority ASC`,
      `LIMIT 12`,
    ],
    joinTbl: [
      `LEFT JOIN ${C_COURSE} ON ${C_COURSE}.e_id = ${C_INSTITUTE}.e_id AND ${C_COURSE}.course_category LIKE '%${sanitizedCourse}%'`,
      `LEFT JOIN ${C_CONTACT} ON ${C_CONTACT}.e_id = ${C_INSTITUTE}.e_id`,
      `LEFT JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${C_CONTACT}.state OR ${STATE_TBL}.state = ${C_CONTACT}.state)`,
      `LEFT JOIN ${CITY_TBL} ON (${CITY_TBL}.ctid = ${C_CONTACT}.city OR ${CITY_TBL}.cname = ${C_CONTACT}.city)`
    ],
  };

  const result = await getCollegeService(queryMap);
  return res.status(200).json({
    status: "success",
    message: "Recommended colleges fetched successfully",
    data: result,
  });
});

module.exports = { getRecommendedCollegesLandingPage };
