const { SCHOOL_DETAIL, SC_SCHOOLCITYMASTER } = require("../../../models/tables");
const { getSchoolDetailsService } = require("../../../services/school.service");
const tryCatch = require("../../../utils/tryCatch");

//@desc just get top schools
//@route GET /api/v1/public/landing-page/recommended-schools
//@access PUBLIC
const getRecommendedSchools = tryCatch(async (req, res) => {

  const { limit = 8, type } = req.query;

  const queryMap = {
    attributes: [
      `${SCHOOL_DETAIL}.sid`,
      `${SCHOOL_DETAIL}.school_logo AS logo`,
      `${SCHOOL_DETAIL}.school_name AS name`,
      `${SCHOOL_DETAIL}.school_url AS url`,
      `city.cityName AS city`,
      `state.cityName AS state`,
    ],
    conditions: [
      `${SCHOOL_DETAIL}.show_on_home = 'Y'`,
      `${SCHOOL_DETAIL}.active = 'Y'`,
    ],
    additional:[
      `ORDER BY ${SCHOOL_DETAIL}.admission_partner DESC, ${SCHOOL_DETAIL}.priority ASC`,
      `LIMIT ${Number(limit) || 8}`
    ],
    joinTbl: [
      `LEFT JOIN ${SC_SCHOOLCITYMASTER} AS state ON (state.cityId = ${SCHOOL_DETAIL}.state OR state.cityName = ${SCHOOL_DETAIL}.state)`,
      `LEFT JOIN ${SC_SCHOOLCITYMASTER} AS city On (city.cityId = ${SCHOOL_DETAIL}.city OR city.cityName = ${SCHOOL_DETAIL}.city)`,
    ],
  };

  if(type){
    queryMap.conditions.push(`(${SCHOOL_DETAIL}.school_type LIKE ? OR ${SCHOOL_DETAIL}.school_affiliated LIKE ?)`)
    queryMap.parameters = [`%${type}%`, `%${type}%`]
  }

  const result = await getSchoolDetailsService(queryMap);

  return res.status(200).json({
    status: "success",
    message: "top schools fetched successfully",
    data: result,
  });

});

module.exports = { getRecommendedSchools };
