const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const { errorMsgEmpty } = require("../../../utils/errors_message");

let [sql, result] = [null, null];

const [
  category,
  course,
  specialization,
  courselevel,
  examlevel,
  delivery,
  schoolfacilty,
  collegefacilty,
  schooltype,
  institute_type 
] = [
  "category",
  "course",
  "specialization",
  "courselevel",
  "exam_level_type",
  "course_delivery",
  "sc_facilities",
  "sc_facilities",
  "schooltype",
  "institute_type"
];

let statement = [];

// @desc get type of education course
// @api GET api/v1/open/education-type
// @access public
const get_educationCourse = tryCatch(async (req, res) => {
 
  const { type, category_id, course_id } = req.query;

  if (!type) throw new Error(`No type found`);
  switch (type) {
    case "category":
      sql = `SELECT cat_id, cat_name, cat_url AS category_url  FROM ${category}`;
      break;
    case "course":
      if (!category_id) throw new Error(`No category_id found`);
      if(Number(category_id)){
        sql = `SELECT course_id, course_name, course_url FROM ${course} WHERE cat_id = ? and active='Y'`;
        statement = [category_id];
      }else{
        let idFromCategoryByUrl = await dbQuery(`SELECT cat_id FROM ${category} WHERE cat_name like ? or cat_url= ? LIMIT 1`, [ "%" + category_id + "%",category_id ]);
        sql = `SELECT course_id, course_name, course_url FROM ${course} WHERE cat_id = ? and active='Y'`;
        statement = [idFromCategoryByUrl[0].cat_id];



        //////////////// SHANI///////////
        // console.log("category_id",category_id)
        // // var idFromCategoryByUrl = await dbQuery(`SELECT cat_id FROM ${category} WHERE cat_url = ? LIMIT 1`, [category_id]);
        // console.log("category_id",category_id)
        // sql = `SELECT  c_id as course_id, course_name as course_name, LOWER(REPLACE(course_name," ","-")) as course_url  FROM engineering_institute_course WHERE course_category=? group by course_name`;
        // // statement = [category_id];
        // statement = [category_id.replace(/.-/g, ' ')];

      }
      break;
    case "specialization":
      let qry = "";
      if (!course_id)
        throw new Error(`No course_id found`);
      var { search } = req.query;
      if (search) qry = `AND spce_name LIKE '%${search}%'`;

      if(Number(course_id)){
        sql = `SELECT spce_name, spec_id, specialization_url FROM ${specialization} WHERE course_id = ? ${qry}`;
        statement = [course_id, category_id, "%" + search + "%"];
      }
      else
      {

        let idFromCategoryByUrl = await dbQuery(`SELECT cat_id FROM ${category} WHERE cat_name like ? or cat_url= ? LIMIT 1`, [ "%" + category_id + "%",category_id ]);
        let idFromcourseByUrl = await dbQuery(`SELECT course_id FROM ${course} WHERE course_name = ? and cat_id = ? LIMIT 1`, [ course_id,idFromCategoryByUrl[0].cat_id]);
        sql = `SELECT spce_name, spec_id, specialization_url FROM ${specialization} WHERE course_id = ? ${qry}`;
        statement = [idFromcourseByUrl[0].course_id,category_id, "%" + search + "%"];
      }

 
      break;
    case "courselevel":
      sql = `SELECT id,name FROM ${courselevel}`;
      statement = [courselevel];
      break;
    case "examlevel":
      sql = `SELECT id,name FROM ${examlevel}`;
      statement = [examlevel];
      break;
    case "delivery":
      sql = `SELECT id,name FROM ${delivery}`;
      statement = [delivery];
      break;
    case "schoolfacilty":
      sql = `SELECT id,name,type FROM ${schoolfacilty} WHERE facility_for = 'school' `;
      break;
    case "collegefacilty":
      sql = `SELECT id,name FROM ${collegefacilty} WHERE facility_for = 'college' and type is null`;
      break;
    case "schooltype":
      sql = `SELECT school_id AS id, name FROM ${schooltype} where active='Y'`;
      break;
    case "collegetype":
      sql = `SELECT id, name FROM ${institute_type}`;
      break;
    default:
      throw new Error(`No type found, check type`);
  }

  result = await dbQuery(sql, [...statement]);
  if (result.length === 0) errorMsgEmpty("No data found", res);
  return res.status(200).json({ sucess: true, data: result });
});

 


const get_careerlistfordropdown = tryCatch(async (req, res) => {
  let cname=req.query.cname
  queryMap= `select content_id as value, career_name as label from career_list where active='Y' and category=(select category from career_list where career_url=?) `;
  const result = await dbQuery(queryMap,[cname]);

  return res.status(200).json({
    status: "success",
    message: "Articles fetched successfully",
    data: result,
  });
});


module.exports = {
  get_educationCourse,
  get_careerlistfordropdown
};
