const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const { errorMsgEmpty } = require("../../../utils/errors_message");

const [
  country,
  collegestate,
  collegecity,
  collegelocation,
  schoolstate,
  schoolcity,
  schoollocation,
  schooldetail,
] = [
  "country_tbl",
  "state_tbl",
  "city_tbl",
  "district_tbl",
  "sc_schoolcitymaster",
  "sc_schoolcitymaster",
  "sc_schoollocationmaster",
  "school_detail",
];

// @desc Get location Details
// @api GET /api/v1/admin/location-type/:location
// @access Private
const get_locationDetails = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let statement = [];
  let qry = "";
  const { loc } = req.params;
  if (!loc) throw new Error(`location required`);
  switch (loc) {
    case "country":
      sql = `SELECT * FROM ${country}`;
      break;
    case "collegestate":
      var { search = "", limit = 30 } = req.query;
      if (search) qry = `AND state LIKE ? LIMIT ${limit}`;
      sql = `SELECT state as state,sid as stateId FROM ${collegestate} WHERE 1 ${qry}`;
      statement = [search + "%"];
      break;
    case "collegecity":
      var { search = "", state = "", limit = 30 } = req.query;
      if (!state) throw new Error(`state id for college required`);
      if (search) qry = `AND cname LIKE ? LIMIT ${limit}`;
      /////////// Shani's Code fetching city name when state === String
      if(isNaN(state)===true){
        sql=`SELECT cname AS city,ctid AS cityId, city_tbl.sid AS state_id FROM city_tbl JOIN state_tbl ON state_tbl.sid=city_tbl.sid WHERE 1=1 AND state_tbl.state =? ${qry}`
        statement = [state, search + "%"];
      }
      else
      {
        sql = `SELECT cname AS city,ctid AS cityId, sid AS state_id FROM ${collegecity} WHERE 1=1 AND sid = ? ${qry}`;
        statement = [state, search + "%"];
      }
      /////////////////////////////// Closed/////     
      // sql = `SELECT cname AS city,ctid AS cityId, sid AS state_id FROM ${collegecity} WHERE 1=1 AND sid = ? ${qry}`;
      // statement = [state, search + "%"];
      break;
    case "collegelocation":
      var { search = "", city = "", limit = 50 } = req.query;
      if (!city) throw new Error(`city id required`);
      if (search) qry = `AND dist_name LIKE ? LIMIT ${limit}`;
      sql = `SELECT dist_name AS location,dist_id AS locationId FROM ${collegelocation} WHERE 1=1 AND state_id = ? ${qry}`;
      statement = [city, search + "%"];
      break;
    case "schoolstate":
      var { search = "", limit = 30 } = req.query;
      // if (search) qry = `AND cityName LIKE ? LIMIT ${limit}`;
      // sql = `SELECT cityName as state,cityId as stateId from ${schoolstate} WHERE 1 AND cityLevel = '0' ${qry}`;
      // statement = [search + "%"];

      if (search) qry = `AND cityName LIKE ? LIMIT ${limit}`;
      sql = `SELECT state as state, state as stateId from ${schooldetail} WHERE 1 and  state!='' GROUP BY state ORDER BY state ASC  ${qry}`;
      statement = [search + "%"];

      break;
    case "schoolcity":
      var { search = "", state = "", limit = 30 } = req.query;
      if (!state) throw new Error(`state id for school required`);
      if (search) qry = `AND cityName LIKE ? LIMIT ${limit}`;
      // sql = `SELECT cityName as city,cityId FROM ${schoolcity} WHERE 1 AND cityLevel = '1' AND parentId = ? ${qry}`;
      // statement = [state, search + "%"];
      if(isNaN(state)===true){
        // sql=`SELECT cname AS city,ctid AS cityId, city_tbl.sid AS state_id FROM city_tbl JOIN state_tbl ON state_tbl.sid=city_tbl.sid WHERE 1=1 AND state_tbl.state =? ${qry}`
        sql=`SELECT city as city, city as cityId FROM ${schooldetail} WHERE 1 and  city!='' AND state like ? GROUP BY city ORDER BY city ASC`

        

        statement = [state, search + "%"];
      }
      else
      {
        sql = `SELECT cname AS city,ctid AS cityId, sid AS state_id FROM ${collegecity} WHERE 1=1 AND sid = ? ${qry} GROUP BY city ORDER BY city ASC`;
        statement = [state, search + "%"];
      }
      break;
    case "schoollocation":
      var { search = "", city = "", limit = 50 } = req.query;
      if (!city) throw new Error(`city id required`);
      if (search) qry = `AND cityName LIKE ? LIMIT ${limit}`;
      // sql = `SELECT cityName as location,cityId FROM ${schoollocation} WHERE parentId = ? ${qry}`;
      // statement = [city, search + "%"];

      sql =` SELECT cityName as location  FROM sc_schoollocationmaster WHERE parentId=(select cityId from sc_schoolcitymaster where  find_in_set(?,cityName))`
      statement = [city, search + "%"];
      break;
    default:
      throw new Error(`location not found`);
  }

  
  
  result = await dbQuery(sql, [...statement]);
  if (result.length === 0) errorMsgEmpty("No data found", res);
  return res.status(200).json({ success: true, data: result });
});

module.exports = {
  get_locationDetails,
};
