const { dbQuery } = require("../../../config/db.config");
const { C_COURSE, SCHOOL_DETAIL } = require("../../../models/tables");
const tryCatch = require("../../../utils/tryCatch");

const clgTblCourse = C_COURSE;
const schoolTblDetails = SCHOOL_DETAIL;

//@desc get specific collge details/courses
//@route GET /api/v1/open/sc-courses/:id
//@access Public
const getCollegeCourses = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let qry = "";
  let attributes = [
    `${clgTblCourse}.c_id AS course_id`,
    `${clgTblCourse}.course_name`,
    `${clgTblCourse}.specialization`,
    `${clgTblCourse}.course_level`,
    `${clgTblCourse}.course_duration`,
    `${clgTblCourse}.course_fee`,
    `${clgTblCourse}.course_duration_type`,
  ];
  const { id } = req.params;
  const { course_id } = req.query;
  if (course_id) {
    attributes.push(
      ...[
        `${clgTblCourse}.e_id AS college_id`,
        `${clgTblCourse}.course_category`,
      ]
    );
    qry = ` AND ${clgTblCourse}.c_id = ? LIMIT 1`;
  }
  sql =
    `SELECT ${attributes.join(
      ", "
    )} FROM ${clgTblCourse} WHERE 1=1 AND e_id = ?` + qry;
  result = await dbQuery(sql, [id, course_id]);
  if (course_id) result = result[0];
  res.status(200).json({
    status: "success",
    data: result,
  });
});

// @desc get school names for become a partner
// @route GET /api/v1/open/school-names
// @access Public
const getSchoolNames = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { search } = req.query;
  let qry = "";
  const attributes = [
    `${schoolTblDetails}.sid AS school_id`,
    `${schoolTblDetails}.school_name`,
    `${schoolTblDetails}.buyer_name AS school_partner`,
  ];
  if (search) {
    qry = ` AND ${schoolTblDetails}.school_name LIKE ?`;
  }
  sql = `SELECT ${attributes.join(
    ", "
  )} FROM ${schoolTblDetails} WHERE 1=1 ${qry} LIMIT 50`;

  // console.log(">>>>>",sql, [`%${search}%`])
  result = await dbQuery(sql, [`%${search}%`]);
  res.status(200).json({
    status: "success",
    data: result,
  });
});

module.exports = {
  getCollegeCourses,
  getSchoolNames,
};
