const {
  SCHOOL_DETAIL,
  TBL_AWARDS,
  TBL_ACCORDION_CONTENT,
  SC_SCHOOLCITYMASTER,
  SCHOOLTYPE,
  TBL_SCHOOL_GRADE_FEE,
} = require("../../../models/tables");
const tryCatch = require("../../../utils/tryCatch");
const { dbQuery } = require("../../../config/db.config");
const {
  getInfrastructureDetails,
} = require("../College/college_details.controller");
const { sanitizedUrlFromParams } = require("../../../utils/sanitizedUrl");
const { getSchoolIdBasedOnUrl } = require("../../../utils/leadAccessCheck");
const {
  getSchoolDetailsService,
  getSchoolAwardsService,
  getSchoolFaqService,
  getSchoolGradeFeeService,
  getsimilarschools,
} = require("../../../services/school.service");
const {
  getSchoolTypeService,
} = require("../../../services/master/schoolType.service");

// @desc get details on one school based on url, its for public to view
// @route GET /api/v1/public/schoolcompare-schools/?url=school-url
// @access PUBLIC
const getSchoolCompareDetailsForPublic = tryCatch(async (req, res) => {
  const { url } = req.query;

 

  let config = []
  let compare=[];
  if (url.includes("-vs-")) {
    config = url.split("-vs-");
    category = "institute";
    config[0]?compare.push(config[0]):null
    config[1]?compare.push(config[1]):null
    config[2]?compare.push(config[2]):null
    config[3]?compare.push(config[3]):null
    
  }
  else
  {
    compare.push(url)
  }

 
   


   
  
  let sid=null
  let sid2=null
  let sid3=null
  let sid4=null

  if(compare[0]){
    sid = await getSchoolIdBasedOnUrl(compare[0]);
  }

  if(compare[1]){
    sid2 = await getSchoolIdBasedOnUrl(compare[1]);
  }


  if(compare[2]){
    sid3 = await getSchoolIdBasedOnUrl(compare[2]);
  }

  if(compare[3]){
    sid4 = await getSchoolIdBasedOnUrl(compare[3]);
  }
 
 
  if (!sid) {
    return res.status(404).json({
      status: "fail",
      message: "School not found",
      data: [],
    });
  }

  
  sql = `SELECT * FROM ${SCHOOL_DETAIL} WHERE 1=1  and `;

  sql+=`(`
  sql+=`${SCHOOL_DETAIL}.sid = ${sid} `

  if(sid2){
    sql+=` or ${SCHOOL_DETAIL}.sid = ${sid2} `
  }

  if(sid3){
    sql+=` or ${SCHOOL_DETAIL}.sid = ${sid3} `
  }
  if(sid4){
    sql+=` or ${SCHOOL_DETAIL}.sid = ${sid4} `
  }
  sql+=`)`
  
  
  const result = await dbQuery(sql);


 

if(result[0] && result[0].infrastructure){
   result[0].infrastructure=await getInfrastructureDetails(result[0].infrastructure)
}

if(result[1] && result[1].infrastructure){
  result[1].infrastructure=await getInfrastructureDetails(result[1].infrastructure)
}


if(result[2] && result[2].infrastructure){
  result[2].infrastructure=await getInfrastructureDetails(result[2].infrastructure)
}

if(result[3] && result[3].infrastructure){
  result[3].infrastructure=await getInfrastructureDetails(result[3].infrastructure)
}

 
  return res.status(200).json({
    success: true,
    data: result,
  });
 
});



const fixSchoolTypeIssue = async (type) => {
  try {
    //shani commented if (type.length === 0 || !type) return [];
    if ((type && type.length === 0) || !type) return [];

    const schoolType = type.split(",");
    const schoolTypeId = [];

    for (let i = schoolType.length - 1; i >= 0; i--) {
      if (Number(schoolType[i]) && Number(schoolType[i]) >= 0) {
        schoolTypeId.push(schoolType.pop());
      } else {
        break;
      }
    }

    if (schoolTypeId.length === 0) return type;

    const queryMap = {
      attributes: [`${SCHOOLTYPE}.name`],
      conditions: [`${SCHOOLTYPE}.school_id IN (${schoolTypeId.join(",")})`],
      parameters: [],
    };

    const result = await getSchoolTypeService(queryMap);

    return Array.from(new Set([...result.map((type) => type.name), ...schoolType])).join(", ");
  } catch (error) {
    throw new Error(error);
  }
};


module.exports = {
  getSchoolCompareDetailsForPublic,
  fixSchoolTypeIssue
};

const setSchoolAttributes = () => {
  const schoolAttributesArr = [];
  const metaAttributes = [
    `${SCHOOL_DETAIL}.metaDescription`,
    `${SCHOOL_DETAIL}.metaKeywords`,
    `${SCHOOL_DETAIL}.pageTitle`,
  ];
  schoolAttributesArr.push(...metaAttributes);
  const schoolAttributes = [
    `${SCHOOL_DETAIL}.sid`,
    `${SCHOOL_DETAIL}.school_name AS name`,
    `${SCHOOL_DETAIL}.school_logo AS logo`,
    `${SCHOOL_DETAIL}.school_image`,
    `${SCHOOL_DETAIL}.address`,
    `city.cityName AS city`,
    `state.cityName AS state`,
    `${SCHOOL_DETAIL}.location`,
    `${SCHOOL_DETAIL}.authorised_by`,
  ];
  schoolAttributesArr.push(...schoolAttributes);
  const schoolAboutAttributes = [
    `${SCHOOL_DETAIL}.about_school AS about`,
    `${SCHOOL_DETAIL}.addmission_process`,
  ];
  schoolAttributesArr.push(...schoolAboutAttributes);
  const schoolKeyStatsAttributes = [
    `${SCHOOL_DETAIL}.school_type AS type`,
    `${SCHOOL_DETAIL}.education_medium`,
    `${SCHOOL_DETAIL}.year AS establish`,
    `${SCHOOL_DETAIL}.school_category`,
    `${SCHOOL_DETAIL}.campus_size`,
    `${SCHOOL_DETAIL}.school_class`,
    `${SCHOOL_DETAIL}.school_affiliated AS approved_by`,
    `${SCHOOL_DETAIL}.str_student_no`,
    `${SCHOOL_DETAIL}.str_teacher_no`,
    `${SCHOOL_DETAIL}.admission_partner AS is_partner`,
  ];
  schoolAttributesArr.push(...schoolKeyStatsAttributes);
  const schoolFeeAttributes = [
    `${SCHOOL_DETAIL}.annual_fee`,
    `${SCHOOL_DETAIL}.estimated_annual_fee`,
    `${SCHOOL_DETAIL}.application_fee`,
    `${SCHOOL_DETAIL}.admission_fee`,
    `${SCHOOL_DETAIL}.security_fee`,
    `${SCHOOL_DETAIL}.other_fee`,
    `${SCHOOL_DETAIL}.tution_fee`,
    `${SCHOOL_DETAIL}.semi_boarding_fee`,
    `${SCHOOL_DETAIL}.full_boarding_fee`,
  ];
  schoolAttributesArr.push(...schoolFeeAttributes);
  const schoolMedaiAttributes = [
    `${SCHOOL_DETAIL}.upload_video1 AS video1`,
    `${SCHOOL_DETAIL}.upload_video2 AS video2`,
    `${SCHOOL_DETAIL}.upload_video3 AS video3`,
    `${SCHOOL_DETAIL}.upload_video4 AS video4`,
    `${SCHOOL_DETAIL}.upload_video5 AS video5`,
    `${SCHOOL_DETAIL}.upload_video6 AS video6`,
    `${SCHOOL_DETAIL}.upload_photo1 AS image1`,
    `${SCHOOL_DETAIL}.upload_photo2 AS image2`,
    `${SCHOOL_DETAIL}.upload_photo3 AS image3`,
    `${SCHOOL_DETAIL}.upload_photo4 AS image4`,
    `${SCHOOL_DETAIL}.upload_photo5 AS image5`,
    `${SCHOOL_DETAIL}.upload_photo6 AS image6`,
  ];
  schoolAttributesArr.push(...schoolMedaiAttributes);
  const schoolInfraAttributes = [
    `${SCHOOL_DETAIL}.infrastructure`,
    `${SCHOOL_DETAIL}.facilities`,
  ];
  schoolAttributesArr.push(...schoolInfraAttributes);
  const schoolExtraFacilitiesAttributes = [
    `${SCHOOL_DETAIL}.school_provide_meal`,
    `${SCHOOL_DETAIL}.cctvsurveillance`,
    `${SCHOOL_DETAIL}.classairconditioned`,
    `${SCHOOL_DETAIL}.str_student_no`,
    `${SCHOOL_DETAIL}.str_teacher_no`,
    `${SCHOOL_DETAIL}.totol_school_strength`,
    `${SCHOOL_DETAIL}.avgstudentperclass`,
    `${SCHOOL_DETAIL}.cocurricular_activities`,
  ];
  schoolAttributesArr.push(...schoolExtraFacilitiesAttributes);
  return schoolAttributesArr;
};
