const {
  SC_SCHOOL_CONTENT,
  SCHOOL_DETAIL,
  SC_SCHOOLCITYMASTER,
  SCHOOLTYPE,
  TBL_ACCORDION_CONTENT,
  SC_SCHOOLLOCATIONMASTER,
} = require("../../../models/tables");
const { dbQuery } = require("../../../config/db.config");
const { sanitizedUrlFromParams } = require("../../../utils/sanitizedUrl");
const {
  getSchoolDetailsService,
  getSchoolContentService,
  getCityLocaltiesService,
  getcitybystate,
  getSchoolFaqService,
} = require("../../../services/school.service");
const tryCatch = require("../../../utils/tryCatch");
const { fixSchoolTypeIssue } = require("./school_details.controller");

const { getSinglevalueByid } = require("../../../utils/leadAccessCheck");

// @desc get details on multiple schools based on url category, its for public to view
// @route GET /api/v1/public/schools/:url
// @access PUBLIC
const getSchoolsListingForPublic = tryCatch(async (req, res) => {
  const { url } = req.params;
  const { offset = 20 } = req.query;
  const { location, category, locality, feerange1, feerange2 } =
    sanitizedUrlFromParams(url);

  let othercityschools = {};
  const queryMap = {};
  queryMap.attributes = [
    `${SCHOOL_DETAIL}.sid`,
    `${SCHOOL_DETAIL}.school_name AS name`,
    `${SCHOOL_DETAIL}.school_url AS url`,
    `${SCHOOL_DETAIL}.school_logo AS logo`,
    `${SCHOOL_DETAIL}.school_image AS mainImg`,
    `${SCHOOL_DETAIL}.school_type AS type`,
    `${SCHOOL_DETAIL}.year AS establish`,
    `${SCHOOL_DETAIL}.full_boarding_fee AS full_boarding_fee`,
    `${SCHOOL_DETAIL}.annual_fee AS annual_fee`,
    `city.cityName AS city`,
    `state.cityName AS state`,
    `${SCHOOL_DETAIL}.school_affiliated`,
    `${SCHOOL_DETAIL}.admission_partner AS is_partner`,
  ];

  if (category == "institute") {
    queryMap.conditions = [];
    queryMap.parameters = [];
  } else {
    queryMap.conditions = [
      `(${SCHOOL_DETAIL}.school_type LIKE ? OR ${SCHOOL_DETAIL}.school_affiliated LIKE ?)`,
    ];
    queryMap.parameters = [`%${category}%`, `%${category}%`];
  }

  queryMap.additional = [
    `ORDER BY ${SCHOOL_DETAIL}.admission_partner DESC, ${SCHOOL_DETAIL}.priority ASC`,
    `LIMIT 0, ${Number(offset)}`,
  ];
  queryMap.joinTbl = [
    `LEFT JOIN ${SC_SCHOOLCITYMASTER} AS city ON (city.cityId = ${SCHOOL_DETAIL}.city OR city.cityName = ${SCHOOL_DETAIL}.city)`,
    `LEFT JOIN ${SC_SCHOOLCITYMASTER} AS state ON (state.cityId = ${SCHOOL_DETAIL}.state OR state.cityName = ${SCHOOL_DETAIL}.state)`,
  ];

  othercityschools = queryMap;

  if (location) {
    if (location !== "india") {
      if (category == "institute") {
        //   if(url.includes("best-schools-in-")){
        //     queryMap.conditions.push(
        //       `(city.cityName LIKE ?)   and (${SCHOOL_DETAIL}.location LIKE ?)`
        //       );
        //       queryMap.parameters.push(
        //         `%${location}`,
        //         `%${locality}`
        //       );
        //   }
        //   else
        //   {
        //   queryMap.conditions.push(
        //   `(city.cityName LIKE ?) or (${SCHOOL_DETAIL}.state LIKE ?) and (${SCHOOL_DETAIL}.location LIKE ?)`
        //   );
        //   queryMap.parameters.push(
        //     `%${location}`,
        //     `%${location}`,
        //     `%${locality}`
        //   );
        // }

        queryMap.conditions.push(
          `(city.cityName LIKE ?) or (${SCHOOL_DETAIL}.state LIKE ?) and (${SCHOOL_DETAIL}.location LIKE ?)`
        );
        queryMap.parameters.push(
          `%${location}`,
          `%${location}`,
          `%${locality}`
        );
      } else {
        // queryMap.conditions.push(`(city.cityName LIKE ?) OR (state.cityName LIKE ?) or (${SCHOOL_DETAIL}.location LIKE ?)`);
        queryMap.conditions.push(
          `(city.cityName LIKE ? OR  state.cityName LIKE ?  or  ${SCHOOL_DETAIL}.location LIKE ?)`
        );
        queryMap.parameters.push(
          `%${location}`,
          `%${location}`,
          `%${location}`
        );
      }
    }
  }

  if (feerange1) {
    if (feerange1 && feerange2) {
      queryMap.conditions.push(
        `${SCHOOL_DETAIL}.full_boarding_fee BETWEEN ? and ? and ${SCHOOL_DETAIL}.full_boarding_fee!='' `
      );
      queryMap.parameters.push(Number(feerange1), Number(feerange2));
    } else {
      queryMap.conditions.push(
        `${SCHOOL_DETAIL}.full_boarding_fee BETWEEN ? and ? and ${SCHOOL_DETAIL}.full_boarding_fee!='' `
      );
      queryMap.parameters.push(0, Number(feerange1));
    }
  }

  if (req.query.pin) {
    queryMap.conditions.push(`(${SCHOOL_DETAIL}.pincode = ?)`);
    queryMap.parameters.push(`${req.query.pin}`);
  }

  // const schoolResult = await getSchoolDetailsService(queryMap);
  const solution = await getSchoolDetailsService(queryMap);

  const schoolResult = [...solution];

  sql = ` SELECT   school_detail.sid, school_detail.school_name AS name, school_detail.school_url AS url, school_detail.school_logo AS logo, school_detail.school_image AS mainImg, school_detail.school_type AS type, school_detail.year AS establish, school_detail.full_boarding_fee AS full_boarding_fee, school_detail.annual_fee AS annual_fee, 
city.cityName AS city, state.cityName AS state, school_detail.school_affiliated, school_detail.admission_partner AS is_partner FROM school_detail LEFT JOIN sc_schoolcitymaster AS city ON (city.cityId = school_detail.city OR city.cityName = school_detail.city) LEFT JOIN sc_schoolcitymaster AS state ON (state.cityId = school_detail.state 
OR state.cityName = school_detail.state) WHERE 1=1  and  school_detail.admission_partner='Y' and  school_detail.other_city LIKE ? order by rand()   LIMIT 0, 5`;
  otherschool = await dbQuery(sql, [`%${location}%`]);

  if (otherschool.length > 0) {
    const indexes = solution.filter((d) => d.is_partner == "Y").length; /// pushing data indexing
    otherschool.forEach(async (val, index) => {
      schoolResult.splice(indexes, 0, otherschool[index]);
    });
  }

  // WE HAVE SOME ISSUES REGARDING SCHOOL TYPE
  // schoolResult.forEach(async (school) => {
  //   school.type = await fixSchoolTypeIssue(school.type);
  // });

  const contentData = await getSchoolContentForListing(url);
  if (contentData instanceof Error || schoolResult instanceof Error) {
    return res.status(400).json({
      success: false,
      message: "No data found",
    });
  }

  const sendData = {};
  sendData.page_description = contentData.pop();
  sendData.schools = schoolResult;

  let newlocation = "";
  if (location == "andhra") {
    newlocation = "andhra pradesh";
  } else if (location == "uttar") {
    newlocation = "uttar pradesh";
  } else if (location == "madhya") {
    newlocation = "madhya pradesh";
  } else if (location == "arunachal") {
    newlocation = "Arunachal Pradesh";
  } else if (location == "himachal") {
    newlocation = "Himachal Pradesh";
  } else if (location == "jammu") {
    newlocation = "Jammu & Kashmir";
  } else {
    newlocation = location;
  }

  const statecheck = await getSinglevalueByid(
    "state",
    "state_tbl",
    "state",
    newlocation
  );
  if (statecheck.state) {
    const querygetcity = {
      attributes: [`${SCHOOL_DETAIL}.city`],

      conditions: [`${SCHOOL_DETAIL}.state = ? and ${SCHOOL_DETAIL}.city!=''`],

      parameters: [statecheck.state],
      additional: [`group by city`],
    };

    const mycity = await getcitybystate(querygetcity);
    sendData.cities = mycity;
  }

  const locationid = await getSinglevalueByid(
    "cityId",
    "sc_schoolcitymaster",
    "cityName",
    location
  );
  if (locationid.cityId > 0) {
    const querymapllocalities = {
      attributes: [
        `${SC_SCHOOLLOCATIONMASTER}.cityName`,
        `${SC_SCHOOLLOCATIONMASTER}.locationcount`,
      ],

      conditions: [
        `${SC_SCHOOLLOCATIONMASTER}.active = 'Y'`,
        `${SC_SCHOOLLOCATIONMASTER}.parentId = ?`,
      ],

      parameters: [locationid.cityId],
      additional: [`AND locationcount > 1`],
    };

    const mylocalties = await getCityLocaltiesService(querymapllocalities);
    sendData.localties = mylocalties;
  }

  // get school faq
  const queryMapFaq = {
    attributes: [
      `${TBL_ACCORDION_CONTENT}.question`,
      `${TBL_ACCORDION_CONTENT}.answer`,
    ],
    conditions: [
      `${TBL_ACCORDION_CONTENT}.url !=''`,
      `${TBL_ACCORDION_CONTENT}.active = 'Y'`,
      `${TBL_ACCORDION_CONTENT}.url like ?`,
    ],
    parameters: [`%${req.params.url}%`],
  };
  const schoolFaqs = await getSchoolFaqService(queryMapFaq);
  if (schoolFaqs) {
    sendData.faq = schoolFaqs;
  }

  // if(location){
  //   const querymapllocalities = {
  //     attributes: [
  //       `${SCHOOL_DETAIL}.location as cityName`
  //     ],

  //     conditions: [

  //       `${SCHOOL_DETAIL}.active = 'Y'`,
  //       `${SCHOOL_DETAIL}.city  like ?`,
  //     ],
  //     parameters: [`%${location}%`],
  //     additional: [`AND location!='' group by cityName `]
  //   };

  //   const mylocalties = await getCityLocaltiesService(querymapllocalities);
  //   sendData.localties=mylocalties

  // }

  // console.log("aa",sendData)

  return res.status(200).json({
    status: "success",
    data: sendData,
  });
});

// @desc search for school name and get name and url for public to view limited to 10
// @route GET /api/v1/public/find/schools?search=
// @access PUBLIC
const getSchoolsSearchForPublic = tryCatch(async (req, res) => {
  const { search } = req.query;
  if (!search) {
    return res.status(400).json({
      success: false,
      message: "Please provide search query",
    });
  }

  const queryMap = {
    attributes: [
      `${SCHOOL_DETAIL}.school_name AS name`,
      `${SCHOOL_DETAIL}.school_url AS url`,
    ],
    conditions: [`${SCHOOL_DETAIL}.school_name LIKE ?`],
    parameters: [`%${search}%`],
  };

  const result = await getSchoolDetailsService(queryMap);
  if (result instanceof Error) {
    return res.status(400).json({
      success: false,
      message: "No data found",
    });
  }

  return res.status(200).json({
    success: true,
    data: result,
  });
});

module.exports = {
  getSchoolsListingForPublic,
  getSchoolsSearchForPublic,
};

const getSchoolContentForListing = async (url) => {
  if (url.lastIndexOf("-in-india") !== -1) {
    url = url.substring(0, url.lastIndexOf("-in-india"));
  }

  try {
    const queryMap = {
      attributes: [
        `${SC_SCHOOL_CONTENT}.school_name AS brief_desc`,
        `${SC_SCHOOL_CONTENT}.school_url`,
        `${SC_SCHOOL_CONTENT}.content AS full_desc`,
      ],
      conditions: [
        `${SC_SCHOOL_CONTENT}.school_url = ?`,
        `${SC_SCHOOL_CONTENT}.is_active = 1`,
      ],
      additional: [`LIMIT 1`],
      parameters: [`${url}`],
    };
    const result = await getSchoolContentService(queryMap);
    if (result instanceof Error) {
      throw new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};
