const { dbQuery } = require("../../../config/db.config");
const { C_INSTITUTE, C_CONTACT, STATE_TBL } = require("../../../models/tables");
const tryCatch = require("../../../utils/tryCatch");

//@desc get top 6 partner colleges for recommendation
//@route GET /api/v1/public/recommend-top-colleges
//@access PUBLIC
const getTopRecommendedColleges = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const attributes = [
    `${C_INSTITUTE}.e_id`,
    `${C_INSTITUTE}.institute_name AS name`,
    `${C_INSTITUTE}.institute_logo AS logo`,
    `${C_INSTITUTE}.institute_url AS url`,
    `${STATE_TBL}.state AS state`,
    `${C_CONTACT}.city AS city`,
  ].join(", ");
  const query = [
    `${C_INSTITUTE}.is_partner = 1`,
    `${C_INSTITUTE}.active = 'Y'`,
    `${C_INSTITUTE}.top_college = 'Y'`,
    `${C_CONTACT}.country = 'India'`,
  ].join(" AND ");
  const joinTbl = [
    `LEFT JOIN ${C_CONTACT} ON ${C_CONTACT}.e_id = ${C_INSTITUTE}.e_id`,
    `LEFT JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${C_CONTACT}.state OR ${STATE_TBL}.state LIKE ${C_CONTACT}.state)`,
  ].join(" ");

  sql = `SELECT ${attributes} FROM ${C_INSTITUTE} ${joinTbl} WHERE ${query} ORDER BY ${C_INSTITUTE}.priority ASC LIMIT 10`;
  result = await dbQuery(sql);

  return res.status(200).json({
    status: "success",
    message: "Top 6 colleges for recommendation",
    data: result,
  });
});


const getAllPartnerColleges = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const attributes = [
    `${C_INSTITUTE}.e_id`,
    `${C_INSTITUTE}.institute_name AS name`,
    `${C_INSTITUTE}.institute_logo AS logo`,
    `${C_INSTITUTE}.institute_url AS url`,
    `${STATE_TBL}.state AS state`,
    `${C_CONTACT}.city AS city`,
  ].join(", ");
  const query = [
    `${C_INSTITUTE}.is_partner = 1`,
    `${C_INSTITUTE}.active = 'Y'`,
    `${C_CONTACT}.country = 'India'`,
  ].join(" AND ");
  const joinTbl = [
    `LEFT JOIN ${C_CONTACT} ON ${C_CONTACT}.e_id = ${C_INSTITUTE}.e_id`,
    `LEFT JOIN ${STATE_TBL} ON (${STATE_TBL}.sid = ${C_CONTACT}.state OR ${STATE_TBL}.state LIKE ${C_CONTACT}.state)`,
  ].join(" ");

  // sql = `SELECT ${attributes} FROM ${C_INSTITUTE} ${joinTbl} WHERE ${query} ORDER BY ${C_INSTITUTE}.priority ASC LIMIT 30`;
  sql = `SELECT ${attributes} FROM ${C_INSTITUTE} ${joinTbl} WHERE ${query} ORDER BY rand() LIMIT 30`;
  result = await dbQuery(sql);
  

  return res.status(200).json({
    status: "success",
    message: "Top 6 colleges for recommendation",
    data: result,
  });
});

module.exports = {
  getTopRecommendedColleges,
  getAllPartnerColleges,
};
