const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const { SC_USER } = require("../../../../models/tables");
const { filterRequiredFields, exportFieldsName } = require("../../requiredFieldsForUpdate.util");
const { getScUserService, updateScUserService } = require("../../../../services/sc_user.service");

// @desc Get only required student application form info
// @route GET /api/v1/student/application-form
// @access Private STUDENT
const get_studentApplicationForm = tryCatch(async (req, res) => {

  const { us_id, user_type } = req.lead;
  if (!Number(us_id) || !user_type) {
    res.statusCode = 400;
    throw new Error("Unauthorized access");
  }

  const queryMap = {
    attributes: [`${SC_USER}.*`],
    conditions: [`${SC_USER}.us_id = ?`, `${SC_USER}.user_type = ?`],
    parameters: [us_id, user_type],
    additional: [`LIMIT 1`],
  };

  const result = await getScUserService(queryMap);
  if(result instanceof Error || !result[0]){
    res.statusCode = 400;
    throw new Error("Error while fetching user data, User might not exist")
  }

  return res.status(200).json({
    success: true,
    data: result.pop(),
  })

});

const update_studentApplicationForm = tryCatch(async (req, res) => {

  const { us_id, user_type } = req.lead;
  if(!Number(us_id) || !user_type){
    res.statusCode = 400;
    throw new Error("Error, user id or type not found")  
  }

  const { update } = req.body;
  if(!update){
    res.statusCode = 400;
    throw new Error("Update body not found")
  }

  const requiredUpdateFields = filterRequiredFields(update, exportFieldsName.fieldsForApplicationForm);
  const { column, value } = updateColumn(requiredUpdateFields);

  const queryMap = {
    update: [column, "us_update_date = NOW()"],
    conditions: [`${SC_USER}.us_id = ?`, `${SC_USER}.user_type = ?`],
    parameters: [...value, us_id, user_type]
  }

  const result = await updateScUserService(queryMap);
  if(result instanceof Error){
    res.statusCode = 400;
    throw new Error("Error while updating user data")
  }

  return res.status(200).json({
    success: true,
    message: "Successfully updated user details"
  })

});

module.exports = {
  get_studentApplicationForm,
  update_studentApplicationForm,
};
