const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const { errorMsgAuth, errorMsgEmpty } = require("../../../../utils/errors_message");
const { SC_USER } = require("../../../../models/tables");

const table = SC_USER;

// @desc Update only required student Profile info
// @route PUT /api/v1/student/password
// @access Private STUDENT
const update_studentPassword = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id, user_type } = req.lead;
  if (!us_id || !user_type) errorMsgAuth("Unauthorized access", res);
  const { old_password, new_password } = req.body;
  if (!old_password || !new_password) throw new Error("No data to update");
  sql = `SELECT us_password FROM ${table} WHERE us_id = ? AND user_type = ?`;
  result = await dbQuery(sql, [us_id, user_type]);
  if (result.length === 0) errorMsgEmpty("No user found", res);
  if (result[0].us_password !== old_password)
    throw new Error("Old password is incorrect");
  sql = `UPDATE ${table} SET us_password = ? WHERE us_id = ? AND user_type = ?`;
  result = await dbQuery(sql, [new_password, us_id, user_type]);
  return res.status(200).json({ success: true, message: "Password updated" });
});

module.exports = {
    update_studentPassword,
}