const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const { errorMsgAuth, errorMsgEmpty } = require("../../../../utils/errors_message");
const { COLLEGE_REVIEW } = require("../../../../models/tables");

const table = COLLEGE_REVIEW;

// @desc Get Student College Review by us_id
// @route GET /api/v1/student/review
// @access Private STUDENT
const get_studentCollegeReview = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  const attributes = [
    `${table}.college_name`,
    `${table}.course_name`,
    `${table}.overall_rate`,
    `${table}.is_approve`,
    `${table}.review_date`,
  ]
  sql = `SELECT ${attributes.join(", ")} FROM ${table} WHERE us_id = ?`;
  result = await dbQuery(sql, [us_id]);
  if (result.length === 0) errorMsgEmpty("No review found", res);
  return res.status(200).json({ success: true, data: result });
});

// @desc Add Student College Review
// @route POST /api/v1/student/review
// @access Private STUDENT
const post_studentCollegeReview = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  const {
    college_name, // college_name or school_name
    college_url,
    student_name,
    mobile,
    overall_rate,
    college_infra,
    college_placement,
    college_life,
    hostel,
    industry_expo,
    college_recomm = 1,
    review_title,
    your_review,
    query_type, //school or college
    email,
    // For College
    course_name,
    // For School
    current_status, // 10th, 12th, Graduation, Post Graduation
    stream_name, // Science, Commerce, Arts
  } = req.body;

  if (
    (!student_name,
    !mobile,
    !overall_rate,
    !your_review,
    !query_type,
    !review_title)
  ) {
    statusCode = 400;
    throw new Error("Some fields are missing");
  }

  sql = `INSERT INTO ${table} (us_id, college_url, college_name, student_name, mobile, overall_rate, college_infra, college_placement, college_life, hostel, industry_expo, college_recomm, review_title, your_review, query_type, email, course_name, current_status, stream_name, review_date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
  result = await dbQuery(sql, [
    us_id,
    college_url,
    college_name,
    student_name,
    mobile,
    overall_rate,
    college_infra,
    college_placement,
    college_life,
    hostel,
    industry_expo,
    college_recomm,
    review_title,
    your_review,
    query_type,
    email,
    course_name,
    current_status,
    stream_name,
  ]);
  if (result.affectedRows === 0) throw new Error("Review not added");
  return res.status(200).json({ success: true, message: "Review added" });
});

module.exports = {
  get_studentCollegeReview,
  post_studentCollegeReview,
};
