const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const {
  errorMsgAuth,
  errorMsgEmpty,
} = require("../../../../utils/errors_message");
const { TBL_PARTNER_STUDENT_QUERY } = require("../../../../models/tables");

const table = TBL_PARTNER_STUDENT_QUERY;

// @desc Get only required student Enquiry
// @route GET /api/v1/student/enquiry
// @access Private STUDENTS
const get_studentEnquiry = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  let attributes = [
    `${table}.sl`,
    `${table}.us_username`,
    `${table}.category`,
    `${table}.message`,
    `${table}.date`,
    `${table}.status`,
    `${table}.reply`,
    `${table}.reply_dt`,
  ];
  const { us_id } = req.lead;
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  sql = `SELECT ${attributes.join(', ')} FROM ${table} WHERE us_id = ? ORDER BY reply_dt DESC`;
  result = await dbQuery(sql, us_id);
  if (result.length === 0) errorMsgEmpty("No enquiry found", res);
  return res.status(200).json({
    success: true,
    data: result,
  });
});

// @desc Post student dashboard Enquiry
// @route POST /api/v1/student/enquiry
// @access Private STUDENTS
const post_studentEnquiry = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  const { us_username = null, category, message, url = null } = req.body;
  if (!category || !message) throw new Error("Category or Message is missing");
  sql = `INSERT INTO ${table} (us_id, us_username, category, message, url, date, status) VALUES (?, ?, ?, ?, ?, NOW(), ?)`;
  result = await dbQuery(sql, [
    us_id,
    us_username,
    category,
    message,
    url,
    "Y",
  ]);
  if (!result.affectedRows) throw new Error("Enquiry not posted");
  return res.status(200).json({
    success: true,
    message: "Enquiry posted",
  });
});

module.exports = {
  get_studentEnquiry,
  post_studentEnquiry,
};
