const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const { errorMsgAuth } = require("../../../../utils/errors_message");
const {
  C_COURSE,
  C_INSTITUTE,
  BUYER_ORDER_DETAILS,
  SC_USER,
} = require("../../../../models/tables");
const { getCollgeIdOnCourseId } = require("../../getLeadBasicInfo.controller");

const table = C_INSTITUTE;
const buyerTbl = BUYER_ORDER_DETAILS;

//@desc get all online payment
//@route GET /api/v1/student/institute-payment
//@access Private Student
const getInstitutePayment = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id: id, user_type: type } = req.lead;
  const collegeId = await getCollgeIdOnCourseId(id);
  if(!collegeId) {
    return res.status(200).json({
      success: 'success',
      data: []
    });
  }
  let attributes = [
    `${table}.application_fee`,
    `${table}.entrance_fee`,
    `${table}.provisional_fee`,
    // `${buyerTbl}.BUYER_ID`,
    // `${buyerTbl}.TXNDATE`,
  ];
  // let joinTbl = `LEFT JOIN ${buyerTbl} ON ${table}.us_id = ${buyerTbl}.BUYER_ID`;
  sql = `SELECT ${attributes.join(", ")} FROM ${table}  WHERE ${table}.e_id = ?`;
  result = await dbQuery(sql, [collegeId]);

  const sendResultDataFormat = []
  result.forEach((item) => {
    if(item.application_fee) sendResultDataFormat.push({ name: 'Application Fee', amount: item.application_fee })
    // if(item.entrance_fee) sendResultDataFormat.push({ name: 'Entrance Fee', amount: item.entrance_fee })
    // if(item.provisional_fee) sendResultDataFormat.push({ name: 'Provisional Fee', amount: item.provisional_fee })
  })

  console.log("sendResultDataFormat", sendResultDataFormat);

  return res.status(200).json({
    success: true,
    data: sendResultDataFormat,
  });
});

module.exports = {
  getInstitutePayment,
};