const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const {
  errorMsgAuth,
  errorMsgEmpty,
} = require("../../../../utils/errors_message");
const { SC_USER,BUYER_ORDER_DETAILS } = require("../../../../models/tables");
const { CLG_STUDENT, SCL_STUDENT } = require("../../../../common/constants");
const { filterRequiredFields, exportFieldsName } = require("../../requiredFieldsForUpdate.util");

const table = SC_USER;

// @desc Get only required student Profile info
// @route GET /api/v1/student/profile
// @access Private STUDENT
const get_studentProfile = tryCatch(async (req, res) => {



  let [sql, result] = [null, null];
  const { us_id, user_type } = req.lead;
  if (!us_id || !user_type) errorMsgAuth("Unauthorized access", res);
  switch (user_type) {
    case CLG_STUDENT:
      const clgAttributes = [
        `${table}.us_fname`,
       `${table}.us_id`, 
        `${table}.us_lname`,
        `${table}.email_1`,
        `${table}.mobile_1`,
        `${table}.alternate_number`,
        `${table}.state`,
        `${table}.district`,
        `${table}.city`,
        `${table}.university_name`,
        `${table}.url`,
        `${table}.course`,
        `${table}.order_id`,
        `${table}.txn_id`,
        `${table}.payment_status`,
        `${table}.address`,
        `${table}.erp`,
        `(select ${BUYER_ORDER_DETAILS}.TXNDATE from buyer_order_details where buyer_order_details.BUYER_ID = ${table}.us_id and buyer_order_details.TXNID = ${table}.txn_id) as txn_date`,
        
      ];
      sql = `SELECT ${clgAttributes.join(", ")}  FROM ${table} WHERE us_id = ? AND user_type = ? LIMIT 1`;
      break;
    case SCL_STUDENT:
      const sclAttributes = [
        `${table}.us_fname`,
        `${table}.us_lname`,
        `${table}.email_1`,
        `${table}.mobile_1`,
      ];
      sql = `SELECT ${sclAttributes.join(", ")}  FROM ${table} WHERE us_id = ? AND user_type = ? LIMIT 1`;
      break;
  }
  const insertBody = [us_id, user_type];
  result = await dbQuery(sql, insertBody);
  if (result.length === 0) errorMsgEmpty("Profile is empty", res);
  return res.status(200).json({ success: true, data: result[0] });
});

// @desc Update only required student Profile info
// @route PUT /api/v1/student/profile
// @access Private STUDENT
const update_studentProfile = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id, user_type } = req.lead;
  if (!us_id || !user_type) errorMsgAuth("Unauthorized access", res);
  const { update } = req.body;
  if (!update) throw new Error("No data to update");
  const requiredFields = filterRequiredFields(update, exportFieldsName.fieldsForLeadsProfile);
  const { column, value } = updateColumn(requiredFields);
  sql = `UPDATE ${table} SET ${column}  WHERE us_id = ? AND user_type = ?`;
  result = await dbQuery(sql, [...value, us_id, user_type]);
  if (result.affectedRows === 0) throw new Error("Cant update profile, table is empty");
  return res.status(200).json({ success: true, message: "Profile updated" });
});

module.exports = {
  get_studentProfile,
  update_studentProfile,
};
