const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const {
  errorMsgAuth,
  errorMsgEmpty,
} = require("../../../../utils/errors_message");
const updateColumn = require("../../../../utils/updateColumn");
const {
  TBL_COMMON_APPLICATION_FORM,
  TBL_SCHOOL_SHORTLIST,
  C_COURSE,
} = require("../../../../models/tables");
const { filterRequiredFields, exportFieldsName } = require("../../requiredFieldsForUpdate.util");

const table = TBL_COMMON_APPLICATION_FORM;
const tblShortlist = TBL_SCHOOL_SHORTLIST;
const collegeCourse = C_COURSE;

// get college e_id after click on shortlist button
// and we are probably getting shortlist from tbl_common_application_form <--- this is the table name

const getCollegeCourses = async (id) => {
  let [sql, result] = [null, null];
  sql = `SELECT course_name, c_id AS course_id FROM ${C_COURSE} WHERE  e_id = ?`;
  result = await dbQuery(sql, [id]);
  return result;
};

// @desc Get only required student Shortlist info
// @route GET /api/v1/student/shortlist-form/:id <-- common form id
// @access Private STUDENTS
const getStudentShortlistForm = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  const { id } = req.params;
  const attributes = [
    `${table}.id`,
    `${table}.e_id`,
    `${table}.c_id`,
    `${table}.name`,
    `${table}.email`,
    `${table}.mobile`,
    `${table}.gender`,
    `${table}.parent_mobile`,
    `${table}.country`,
    `${table}.state`,
    `${table}.city`,
    `${table}.dob`,
    `${table}.caste`,
    `${table}.mother_tongue`,
    `${table}.passing_year_10`,
    `${table}.school_name_10`,
    `${table}.board_10`,
    `${table}.evaluation_10`,
    `${table}.percentage_10`,
    `${table}.passing_year_12`,
    `${table}.school_name_12`,
    `${table}.board_12`,
    `${table}.percentage_12`,
    `${table}.stream_12`,
    `${table}.result_status_12`,
    `${table}.have_gradut`,
    `${table}.passing_gradut`,
    `${table}.college_gradut`,
    `${table}.university_gradut`,
    `${table}.study_mode_gradut`,
    `${table}.exam_type_gradut`,
    `${table}.specialization_gradut`,
    `${table}.degree_gradut`,
    `${table}.accomodation_require`,
    `${table}.accomodation_type`,
    `${table}.any_entrance`,
    `${table}.entrance_type`,
    `${table}.entrance_score`,
    `${table}.current_step`
  ];
  sql = `SELECT ${attributes.join(', ')} FROM ${table} WHERE us_id = ? AND id = ? LIMIT 1`;
  result = await dbQuery(sql, [us_id, id]);
  // const collegeCourse = await getCollegeCourses(e_id);
  if (result.length === 0) throw new Error("No data found for this user");
  return res
    .status(200)
    .json({ success: true, data: result[0] });
});

// @desc PUT only required student Shortlist info
// @route PUT /api/v1/student/shortlist-form/:id
// @access Private STUDENTS
const putStudentShortlistForm = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  const { id } = req.params;
  const { update } = req.body;
  if (!id || !update) throw new Error("Invalid data, add id and update");
  const requiredFields = filterRequiredFields(update, exportFieldsName.fieldsForShortlistForm);
  const { column, value } = updateColumn(requiredFields);
  sql = `UPDATE ${table} SET ${column} WHERE id = ? AND us_id = ?`;
  result = await dbQuery(sql, [...value, id, us_id])
  if (!result.affectedRows) throw new Error("Unable to update");
  return res.status(200).json({ success: true, message: "Updated shortlist" });
});

module.exports = {
  getStudentShortlistForm,
  putStudentShortlistForm,
};
