const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const updateColumn = require("../../../../utils/updateColumn");
const {
  errorMsgEmpty,
  errorMsgAuth,
} = require("../../../../utils/errors_message");
const { PARTNER_STUDENT_DOC } = require("../../../../models/tables");

const table = PARTNER_STUDENT_DOC;

const { getSinglevalueByid }  = require("../../../../utils/leadAccessCheck")

// @desc Get student college documents
// @route GET /api/v1/student/college-doc based on us_id
// @access Private STUDENT
const getCollegeStdDoc = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  sql = `SELECT profile_pic, aadhar_front, aadhar_back, ten_marksheet, twel_marksheet, gradut_marksheet, post_graduate, caste, fee_receipt, signature, neet_score_card FROM ${table} WHERE us_id = ? LIMIT 1`;
  result = await dbQuery(sql, [us_id]);
  if (result.length === 0) errorMsgEmpty("No college document found", res);
  return res.status(200).json({ success: true, data: result[0] });
});

// @desc Upload student college documents
// @route POST /api/v1/student/college-doc based on us_id
// @access Private STUDENT
const postCollegeStdDoc = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  const {
    profile_pic,
    aadhar_front,
    aadhar_back,
    ten_marksheet,
    twel_marksheet,
    gradut_marksheet,
    post_graduate,
    caste,
    fee_receipt,
    signature,
    neet_score_card,
  } = req.body;
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  sql = `INSERT INTO ${table} (us_id, profile_pic, aadhar_front, aadhar_back, ten_marksheet, twel_marksheet, gradut_marksheet, post_graduate, caste, fee_receipt, signature, neet_score_card, date) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())`;
  result = await dbQuery(sql, [
    us_id,
    profile_pic,
    aadhar_front,
    aadhar_back,
    ten_marksheet,
    twel_marksheet,
    gradut_marksheet,
    post_graduate,
    caste,
    fee_receipt,
    signature,
    neet_score_card,
  ]);
  if (result.affectedRows === 0) throw new Error("Unable to add document");
  return res.status(200).json({ success: true, message: "Document added" });
});

// @desc Update student college documents
// @route PUT /api/v1/student/college-doc based on us_id
// @access Private STUDENT
const updateCollegeStdDoc = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  const { update } = req.body;
  if (!us_id || !update) errorMsgAuth("Unauthorized access", res);
  const { column, value } = updateColumn(update);

  const checkdoctable = await getSinglevalueByid("us_id","partner_student_doc","us_id",us_id);
  if(checkdoctable.us_id>0)
  {
    sql = `UPDATE ${table} SET ${column} WHERE us_id = ?`;
    result = await dbQuery(sql, [...value, us_id]);
    if (result.affectedRows === 0) throw new Error("Unable to update document");
    return res.status(200).json({ success: true, message: "Document updated" });

  }
  else
  {
    const leadDocResult = await dbQuery(`INSERT INTO ${table} (us_id) VALUES (?)`, [us_id]);
    if(!leadDocResult.affectedRows) {

      sql = `UPDATE ${table} SET ${column} WHERE us_id = ?`;
      result = await dbQuery(sql, [...value, us_id]);
      if (result.affectedRows === 0) throw new Error("Unable to update document");
      return res.status(200).json({ success: true, message: "Document updated" });

    }
  }

  
 
});

// @desc Delete student college documents ALL
// @route DELETE /api/v1/student/college-doc based on us_id
// @access Private STUDENT
const deleteCollegeStdDoc = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  const { confirm = "no" } = req.body;
  if (confirm !== "yes") throw new Error("Please confirm to delete");
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  sql = `DELETE FROM ${table} WHERE us_id = ?`;
  result = await dbQuery(sql, [us_id]);
  if (result.affectedRows === 0) throw new Error("Unable to delete document");
  return res.status(200).json({ success: true, message: "Document deleted" });
});

module.exports = {
  getCollegeStdDoc,
  postCollegeStdDoc,
  updateCollegeStdDoc,
  deleteCollegeStdDoc,
};
