"use strict"
const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const { FORGOT_PSWD } = require("../../../controllers/admin/CMS/EmailTemplate/sms_template_contants");
const { SC_USER } = require("../../../models/tables");
const cryptPassword = require("../../../utils/cryptPassword");
const axios = require("axios");

const table = SC_USER;

const { SMS_USERNAME, SMS_PSWD, SENDER_ID } = process.env;

const smsURL = (mobile, otpTemplate) => {
 return  `http://sms.mishtel.net/api/mt/SendSMS?user=${SMS_USERNAME}&password=${SMS_PSWD}&senderid=${SENDER_ID}&channel=Trans&DCS=0&flashsms=0&number=${mobile}&text=${otpTemplate}(INTASC)&route=1`;
};

const generatePassword = () => {
  let password = "";
  const possibleChars = "0123456789"; // only numbers as per asked
  for (let i = 0; i < 8; i++) {
    // loop 8 times to create 8-digit password
    password += possibleChars.charAt(
      Math.floor(Math.random() * possibleChars.length)
    ); // add a random character to password
  }
  return password;
};

const forgotPass = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { email, user_type } = req.body;
  if (!email || !user_type) throw new Error("Please fill all required fields");

  sql = `SELECT us_id, mobile_1, us_fname  FROM ${table} WHERE email_1 = ? AND user_type = ? LIMIT 1`;
  result = await dbQuery(sql, [email, user_type]);
  if (result.length === 0) {
    res.statusCode = 404;
    throw new Error("No user found with this email, check your email or user type");
  }

  const { us_id: id, mobile_1: mobile, us_fname: name } = result[0];

  const pswd = generatePassword();
  const encryptedPswd = cryptPassword(pswd);

  sql = `UPDATE ${table} SET us_password = ? WHERE us_id = ? AND user_type = ?`;
  result = await dbQuery(sql, [encryptedPswd, id, user_type]);
  if (result.affectedRows === 0) {
    res.statusCode = 500;
    throw new Error("Password not updated");
  }

  const otpTemplate = FORGOT_PSWD.replace("{#name#}", name).replace("{#psw#}",pswd);
  const smsOptions = {
    method: "GET",
    url: smsURL(mobile,otpTemplate),
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
    },
  };

  axios(smsOptions)
    .then((response) => {
      if (response.data.ErrorCode !== "000") throw response.data.ErrorMessage;
      return res.status(200).json({
        success: true,
        message: "Password sent to your mobile number",
      });
    })
    .catch((error) => {
      console.log(error);
      return res.status(500).json({
        success: false,
        message: "Password not sent",
        error,
      });
    });
});

module.exports = {
  forgotPass,
};
