"use strict";
const tryCatch = require("../../../utils/tryCatch");
const axios = require("axios");
const {
  SEND_OTP,
} = require("../../admin/CMS/EmailTemplate/sms_template_contants");
const NodeCache = require("node-cache");
const uuid = require("short-uuid");

const otpCache = new NodeCache();

const { SMS_USERNAME, SMS_PSWD, SENDER_ID } = process.env;

const smsURL = (mobile, otpTemplate) => {
  return `http://sms.mishtel.net/api/mt/SendSMS?user=${SMS_USERNAME}&password=${SMS_PSWD}&senderid=${SENDER_ID}&channel=Trans&DCS=0&flashsms=0&number=${mobile}&text=${otpTemplate}(INTASC)&route=1`;
};

// Generate 6 digit OTP
const generateOTP = () => {
  const digits = "0123456789";
  let OTP = "";
  for (let i = 0; i < 6; i++) {
    OTP += digits[Math.floor(Math.random() * 10)];
  }
  return OTP;
};

// @desc Get Otp from Frontend
// @route /api/v1/open/otp
// @access Public
const getOtpForVerification = tryCatch(async (req, res) => {
  const { mobile, name } = req.body;
  if (!mobile || !name)
    throw new Error("Mobile number, OTP and Name are required");

  const generatedOTP = generateOTP();

  const otpTemplate = SEND_OTP.replace("{#name#}", name).replace(
    "{#otp#}",
    generatedOTP
  );

  const smsOptions = {
    method: "GET",
    url: smsURL(mobile, otpTemplate),
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
    },
  };

  // Save OTP in cache with uuid as key
  const uuidKey = uuid.generate();
  otpCache.set(mobile, generatedOTP, 120);

  axios(smsOptions)
    .then((response) => {
      if (response.data.ErrorCode !== "000") throw response.data.ErrorMessage;
      return res.status(200).json({
        success: true,
        message: "OTP sent successfully",
        id: uuidKey,
      });
    })
    .catch((error) => {
      console.log(error);
      return res.status(500).json({
        success: false,
        message: "OTP not sent",
      });
    });
});

// @desc Verify Otp from Frontend
// @route /api/v1/open/otp/verify
// @access Public
const verifyOtp = tryCatch(async (req, res) => {
  const { otpId, otp, mobile } = req.body;
  if (!otpId || !otp || !mobile) throw new Error("optId and otp are required");
  const cachedOtp = otpCache.get(mobile);
  if (!cachedOtp) throw new Error("Invalid OTP");
  if (cachedOtp === otp) {
    otpCache.del(otpId);
    return res.status(200).json({
      success: true,
      message: "OTP verified successfully",
    });
  } else {
    return res.status(400).json({
      success: false,
      message: "Invalid OTP",
    });
  }
});

module.exports = {
  getOtpForVerification,
  verifyOtp,
};
