const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const generateToken = require("../../../utils/jwtGenerate");
const {
  SC_USER,
  TBL_SCHOOL_STUDENT,
  TBL_STUDENT_CART,
} = require("../../../models/tables");
const {
  SCL_STUDENT,
  SCHOOL,
} = require("../../../common/constants");
const {
  checkLeadAlreadyExist,
  getSchoolsBasicDetails,
} = require("../../../utils/leadAccessCheck");
const { transporter } = require("../../admin/CMS/EmailTemplate/email");

const parentTbl = SC_USER;
const childTbl = TBL_SCHOOL_STUDENT;
const cartTbl = TBL_STUDENT_CART;
const { EMAIL_FROM } = process.env;




const signupForSchoolStudents = tryCatch(async (req, res) => {

  
  const {
    full_name, // student name
   // dob, // date of birth of student
    std, // standard for applying
    parent_name, // father name // parent_name
    // mother_name, // mother name
    country = "91", // India
    parent_mobile, // father mobile number5 // parent_mobile
    parent_email, // father email // parent_email
    state,
    city,
    us_password,
    school_id, // school id
  } = req.body;

  if (
    !full_name ||
    // !dob ||
    !std ||
    // !parent_name ||
    !parent_email ||
    //!mother_name ||
    !parent_mobile ||
    !state ||
    !city ||
    !us_password ||
    !school_id
  ) {
    throw new Error("Unauthorized access, some fields are missing");
  }

  dob=null
  mother_name=null
  
  
  // Check if email already exists
  if (await checkLeadAlreadyExist(parent_email, SCL_STUDENT)) {
    res.statusCode = 400;
    throw new Error("Email already exists, Please login");
  }

  // Check if school id exists
  const isPartner = "Y";
  const getSchoolDetails = await getSchoolsBasicDetails(school_id, isPartner);
  if (!getSchoolDetails) {
    throw new Error("School not found, or isn't a partner");
  };
  const schoolUrlForLead = getSchoolDetails.school_url;
  const schoolNameForCart = getSchoolDetails.school_name;
  const schoolRegFee = getSchoolDetails?.asc_reg_fee || 0;

  if (!schoolUrlForLead || !schoolNameForCart) {
    throw new Error("School url not found");
  }

  // Insert into parent/lead table
  const leadAttributes = [
    `${parentTbl}.us_username`,
    `${parentTbl}.us_password`,
    `${parentTbl}.us_fname`,
    `${parentTbl}.us_lname`,
    `${parentTbl}.mother_name`,
    `${parentTbl}.parent_name`,
    `${parentTbl}.mobile_1`,
    `${parentTbl}.parent_mobile`,
    `${parentTbl}.parent_email`,
    `${parentTbl}.email_1`,
    `${parentTbl}.state`,
    `${parentTbl}.city`,
    `${parentTbl}.country`,
    `${parentTbl}.url`,
    `${parentTbl}.user_type`,
    `${parentTbl}.school_college`
  ];
  const leadInsertBody = [
    parent_email,
    us_password,
    parent_name.split(" ")[0],
    parent_name.split(" ")[1],
    mother_name,
    parent_name,
    parent_mobile,
    parent_mobile,
    parent_email,
    parent_email,
    state,
    city,
    country,
    schoolUrlForLead,
    SCL_STUDENT,
    "buyer",
    "school"
  ];
  // console.log("leadInsertBody",leadInsertBody)


 
   const now =  new Date().toLocaleString("en", { timeZone: "Asia/Calcutta" })

 

  const leadSql = `INSERT INTO ${parentTbl} (${leadAttributes.join(", ")},us_create_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,'${now}')`;
  const leadInsertResult = await dbQuery(leadSql, leadInsertBody);
  if (!leadInsertResult.insertId) {
    throw new Error("Lead insertion failed");
  }
  const leadId = leadInsertResult.insertId;

  // Insert into child table
  const childAttributes = [
    `${childTbl}.us_id`,
    `${childTbl}.full_name`,
    `${childTbl}.dob`,
    `${childTbl}.std`,
    `${childTbl}.form_status`,
    `${childTbl}.gender`,
  ];
  const childInsertBody = [leadId, full_name, dob, std, "pending", "M"];
  const childSql = `INSERT INTO ${childTbl} (${childAttributes.join(", ")}, date) VALUES (?,?,?,?,?,?, NOW())`;
  const childInsertResult = await dbQuery(childSql, childInsertBody);
  if (!childInsertResult.insertId) {
    let delParentSql = `DELETE FROM ${parentTbl} WHERE us_id = ?`;
    let delResult = await dbQuery(delParentSql, [leadId]);
    throw new Error("Child insertion failed, Please check all fields and try again");
  }
  const childId = childInsertResult.insertId;

  // Insert into cart table
  const date = new Date();
  const session = date.getFullYear() + " - " + (date.getFullYear() + 1);
  const cartAttributes = [
    `${cartTbl}.institute_name`,
    `${cartTbl}.institute_id`,
    `${cartTbl}.institute_type`,
    `${cartTbl}.us_id`,
    `${cartTbl}.child_id`,
    `${cartTbl}.std`,
    `${cartTbl}.session`,
    `${cartTbl}.reg_fee`,
  ];
  const cartInsertBody = [
    schoolNameForCart,
    school_id,
    SCHOOL,
    leadId,
    childId,
    std,
    session,
    schoolRegFee,
  ];
  const cartSql = `INSERT INTO ${cartTbl} (${cartAttributes.join(", ")}, date) VALUES (?,?,?,?,?,?,?,?,NOW())`;
  const cartInsertResult = await dbQuery(cartSql, cartInsertBody);
  if (!cartInsertResult.insertId) {
    throw new Error("Cart insertion failed");
  }



  let mailcontent=`<table style="border-collapse:collapse; border:1px solid #ddd;" align="center" width="70%">
<tr><td>&nbsp;</td></tr>
<tr>
	<tr>
		<td>
			<img src="https://www.allschoolscolleges.com/red-logo.png" style="padding: 0px; float: left; width: auto; height: 90px; margin-left: 5px;" />
		</td>
	</tr>
	
	<tr><td style="border-bottom:3px solid #FF4E00;">&nbsp;</td></tr>
	
	<tr>
		<td>
		<p style="padding:20px;">
		<b>Dear ${parent_name.split(" ")[0]},</b><br/><br/>

Thank you for showing your interest</b><br/><br/>

Login URL : <a href="https://www.allschoolscolleges.com/student/login" target="_blank">https://www.allschoolscolleges.com/student/login</a><br/>
User id / Email: ${parent_email}<br/>

Password : ${parent_mobile.toString().substr(-6)}<br/><br/><br/>

For any query call : 7703865712<br/><br/>

Best Regards<br/>
AllSchoolsColleges.com Team<br/>
Website: <a href="www.allschoolscolleges.com" target="_blank"> www. AllSchoolsColleges.com</a><br/><br/>

<a href="https://www.facebook.com/allschoolscolleges" target="_blank"><img src="https://www.allschoolscolleges.com/facebook.png"></a> <a href="https://twitter.com/allschoolscoleg" target="_blank"><img src="https://www.allschoolscolleges.com/twitter.png"></a> <a href="https://www.linkedin.com/school/allschoolscolleges/" target="_blank"><img src="https://www.allschoolscolleges.com/linkedin.png"></a> <a href="https://www.youtube.com/c/allschoolscolleges" target="_blank"><img src="https://www.allschoolscolleges.com/youtube.png"></a><br/>

</p>

    	</td>
    </tr>

</tr>
</table>`;



//let mails= req.body["email_1"]
let mails= parent_email
//  console.log("emailids.emailids",mails)
   
var mailOptions = {
  from: EMAIL_FROM,    // sender address
  // to: 'shani.intactadvt@gmail.com, iamsmartsunny@gmail.com', // list of receivers
  to: mails, // list of receivers
  subject: `Account Details with AllSchoolsColleges.com`, // Subject line
  // text: 'Hello world from Node.js',       // plaintext body
  html: mailcontent // html body
};
 


transporter.sendMail(mailOptions, function (error, info) {
    if (error) {
      // return res.status(500).json({
      //   success: false,
      //   message: "Email not sent",
      //   error: error,
      // });
    }
  });

  // Generate token
  const token = generateToken({us_id:leadId, user_type:SCL_STUDENT});
  return res.status(200).json({
    success: true,
    message: "Account created",
    insertid:leadId,
    auth_token: token,
  });

});

module.exports = { signupForSchoolStudents };
