const { dbQuery } = require("../../../config/db.config");
const tryCatch = require("../../../utils/tryCatch");
const generateToken = require("../../../utils/jwtGenerate");
const { SC_USER, PARTNER_STUDENT_DOC } = require("../../../models/tables");
const { CLG_STUDENT} = require("../../../common/constants")
const { checkLeadAlreadyExist, checkCollegeExistByUrlCourse,getSinglevalueByid,checkLeadShortlistAlreadyExist }  = require("../../../utils/leadAccessCheck")



const { collgeSignupFields } = require("./create_signup_content");
const openapply = require("../../../middlewares/openapplyperform");
const thirdpartyapi = require("../../../middlewares/thirdpartyapi");
const { transporter } = require("../../admin/CMS/EmailTemplate/email");
const table = SC_USER;
const leadDocTbl = PARTNER_STUDENT_DOC;
const { EMAIL_FROM } = process.env;


// THIS IS FOR COLLEGE BUYER PARENT SIGNUP
// ONLY COLLEGE SIGNUP IS SAME BUT WITH LESS FIELDS, WE DONT NEED COURSE, CASTE, ADDRESS, ETC

// @desc POST Signup
// @route POST /api/v1/student/signup
// @access Public

 
 
const signup = tryCatch(async (req, res) => {
  const {user_type } = req.body;

  

  let [sql, result,collegelogo] = [null, null,[]];
  const attributes = [];
  const insertBody = [];
  collgeSignupFields.forEach((field) => {
    if (req.body[field]) {
      attributes.push(`${table}.${field}`);
      insertBody.push(req.body[field]);
    }
  });
  const requiredFields = ["email_1","us_fname","mobile_1","city","state","course", "user_type"];
  const missingFields = requiredFields.filter((field) => !req.body[field]);
  if (missingFields.length) {
    res.statusCode = 400;
    throw new Error(`Missing fields: ${missingFields.join(", ")}`);
  }



  collegelogo = await getSinglevalueByid("institute_logo","engineering_institute","e_id",req.body["college_id"]);


  



  // Check if email already exists
  if (await checkLeadAlreadyExist(req.body["email_1"], CLG_STUDENT)){
    // res.statusCode = 400;
    //throw new Error("Email already exists, Please login");

    


  const studentid = await getSinglevalueByid("us_id","sc_user","us_username",req.body["email_1"]);
  const leadShortlistDoesNotExist = await checkLeadShortlistAlreadyExist(req.body.college_id, studentid.us_id, user_type,req.body["course"]);

  


  if(leadShortlistDoesNotExist){
   
    const shortlistQuery = `INSERT INTO tbl_school_shortlist (us_id, usertype, school_id, c_id, source, date) VALUES (?, ?, ?, ?, ?, NOW())`;
    const clgShortlistResult = await dbQuery(shortlistQuery, [studentid.us_id, user_type, req.body.college_id,req.body["course"],'enq']);
    
    const commonFormQuery = `INSERT INTO tbl_common_application_form (us_id, e_id, c_id, form_status ,date) VALUES (?, ?, ?, ?, NOW())`;
    const commonFormResult = await dbQuery(commonFormQuery, [studentid.us_id, req.body.college_id,req.body["course"], "pending"]);
 

  }

  const username = await getSinglevalueByid("us_fname","sc_user","us_username",req.body["email_1"]);

  return res.status(200).json({
    success: true,
    message: "Account created",
    auth_token: generateToken({ us_id: studentid.us_id, user_type: CLG_STUDENT, us_fname:username.us_fname,partner_icon:collegelogo.institute_logo }),
    // payment:payment?generateToken(payment):''
  });
    

    // return res.status(400).json({
    //   success: false,
    //   message: "Email already exists",
    // });
  }


 

  
  
 

  // const addpen = await addopen("Hi shani")
  // console.log("addpen",addpen)
   

  // let attributes = [
  //   `${table}.email_1`,
  //   `${table}.us_password`,
  //   `${table}.us_username`,
  //   `${table}.us_fname`,
  //   `${table}.us_lname`,
  //   `${table}.us_gender`,
  //   `${table}.mobile_1`,
  //   `${table}.address`,
  //   `${table}.city`,
  //   `${table}.district`,
  //   `${table}.state`,
  //   `${table}.country`,
  //   `${table}.alternate_number`,
  //   `${table}.course`,
  //   `${table}.user_type`,
  //   `${table}.specialization`,
  // ];

  // let insertBody = [
  //   email_1,
  //   us_password,
  //   email_1, // username is email
  //   us_fname,
  //   us_lname,
  //   us_gender,
  //   us_date_of_birth,
  //   mobile_1,
  //   address,
  //   city,
  //   district,
  //   state,
  //   country,
  //   alternate_number,
  //   parent_name,
  //   mother_name,
  //   caste_category,
  //   course,
  //   CLG_STUDENT,
  //   specialization,
  // ]

  let collegeId = null;
  let courseId = null;

  if(req.body["college_url"] && req.body["college_id"]){
    const doesCollegeExist = await checkCollegeExistByUrlCourse(req.body["college_url"], req.body["course"]);
    if(!doesCollegeExist) throw new Error("College does not exist or the course, check the url");
    const additionalFields = [
      `${table}.us_date_of_birth`,
      `${table}.parent_name`,
      `${table}.mother_name`,
      `${table}.caste_category`,
      `${table}.url`,
      `${table}.us_gender`,
    ];
    const additionalInsertBody = [
      req.body["us_date_of_birth"],
      req.body["parent_name"],
      req.body["mother_name"],
      req.body["caste_category"],
      req.body["college_url"],
      req.body["us_gender"]
      
    ]
    attributes.push(...additionalFields);
    insertBody.push(...additionalInsertBody);
    collegeId = req.body["college_id"];
    courseId = req.body["course"];
  }

  const requiredPreStatements = attributes.map((attr) => '?');

  sql = `INSERT INTO ${table} (${attributes.join(", ")}, us_create_date, us_username, school_college) VALUES (${requiredPreStatements.join(", ")}, NOW(), '${req.body["email_1"]}', 'college')`;
  result = await dbQuery(sql, insertBody);
  const leadId = result.insertId
  if (!result.affectedRows) throw new Error("Unable to create account");
  const leadDocResult = await dbQuery(`INSERT INTO ${leadDocTbl} (us_id) VALUES (?)`, [result.insertId]);
  if(!leadDocResult.affectedRows) {
    const deleteLeadSql = `DELETE FROM ${table} WHERE us_id = ?`;
    const delLeadResult = await dbQuery(deleteLeadSql,[leadId])
    throw new Error("Unable to create documents, please try again");
  }

 

// const post_options = {
//   hostname:"https://api.openapply.in",
//   method : "POST",
//   path: "/external-leads-college/",
//   headers : {
//     "Content-Type": "application/json"
//   },
//   body: JSON.stringify(cartItem),    
// }

// const post_request = https.request(post_options,(response) => {

// console.log(`Response Code: ${response.statusCode}`);

// response.pipe(process.stdout)
// })

// post_request.on("error", (err) =>{})
// post_request.end(cartItem)




  // const https = require('https');
  // https.get('https://api.openapply.in/templates',(response)=>{
  //   let data = '';
  //   response.on('data',(chunk)=>{
  //     data += chunk;

  //   })

  //   response.on('end',()=>{
  //     console.log(data)
  //   })

  // })
  // .on('error',(error)=>{
  //   console.log(error)

  // })

 
 
 
  
//   const body = {
//     "name":req.body["full_name"],
//     "email":req.body["email_1"],
//     "country_code":req.body["full_name"],
//     "mobile":"9898989898",
//     "state":req.body["state"],
//     "city":req.body["city"],
//     "college_name" : req.body["college_id"],
//     "assign_counselor" : "",
//     "assign_for_college" : "",
//     "father" : req.body["parent_name"],
//     "category" : req.body["caste_category"],
//     "course" : req.body["course"],
//     "specialization" : req.body["course"],
//     "lead_source" : "Allschools",
//     "us_id" : leadId,
//     "neet_score" : "111",
//     "caste" : req.body["caste_category"]
//     };

  

//   url='https://api.openapply.in/external-leads-college/';
// request({
//       url: url,
//       method: 'POST',
//       headers: {
//           "Content-Type": "application/json" 
//       },

//       body: JSON.stringify(body),  
      
//   }, function (error, response, body) {
//       if (error) throw error;
//       // console.log(body);
//       // return res.status(200).json(body);

//       console.log(response)
//   });

 

const cityname = await getSinglevalueByid("cname","city_tbl","ctid",req.body["city"]);
const statename = await getSinglevalueByid("state","state_tbl","sid",req.body["state"]);
const collegename = await getSinglevalueByid("institute_name","engineering_institute","e_id",req.body["college_id"]);
const course = await getSinglevalueByid("course_name","engineering_institute_course","c_id",req.body["course"]);
const specialization = await getSinglevalueByid("specialization","engineering_institute_course","c_id",req.body["course"]);



let firstname=req.body["us_fname"];
let lastname= req.body["us_lname"]?" "+req.body["us_lname"]:'' ;

const insertvalue={
  name:firstname+lastname, 
  email:req.body["email_1"], 
  country_code:"+91", 
  mobile:req.body["mobile_1"], 
  state:statename.state, 
  city:cityname.cname, 
  college_name:collegename.institute_name, 
  castecategory:req.body["caste_category"], 
  father:req.body["parent_name"], 
  course:course.course_name, 
  specialization:specialization.specialization,
  insertid:leadId,
  neetscore:""
}

const updateval={updatecol:"npf_response",table:"sc_user",updatekey:"us_id",updateid:leadId}
const resptd= openapply.addopenapply(insertvalue,updateval)





let mailcontent=`<table style="border-collapse:collapse; border:1px solid #ddd;" align="center" width="70%">
<tr><td>&nbsp;</td></tr>
<tr>
	<tr>
		<td>
			<img src="https://www.allschoolscolleges.com/red-logo.png" style="padding: 0px; float: left; width: auto; height: 90px; margin-left: 5px;" />
		</td>
	</tr>
	
	<tr><td style="border-bottom:3px solid #FF4E00;">&nbsp;</td></tr>
	
	<tr>
		<td>
		<p style="padding:20px;">
		<b>Dear ${firstname+lastname},</b><br/><br/>

Thank you for showing your interest in <b>${collegename.institute_name}</b><br/><br/>

Login URL : <a href="https://www.allschoolscolleges.com/student/login" target="_blank">https://www.allschoolscolleges.com/student/login</a><br/>
User id / Email: ${req.body["email_1"]}<br/>

Password : ${req.body["mobile_1"].toString().substr(-6)}<br/><br/><br/>

For any query call : 7703865712<br/><br/>

Best Regards<br/>
AllSchoolsColleges.com Team<br/>
Website: <a href="www.allschoolscolleges.com" target="_blank"> www. AllSchoolsColleges.com</a><br/><br/>

<a href="https://www.facebook.com/allschoolscolleges" target="_blank"><img src="https://www.allschoolscolleges.com/facebook.png"></a> <a href="https://twitter.com/allschoolscoleg" target="_blank"><img src="https://www.allschoolscolleges.com/twitter.png"></a> <a href="https://www.linkedin.com/school/allschoolscolleges/" target="_blank"><img src="https://www.allschoolscolleges.com/linkedin.png"></a> <a href="https://www.youtube.com/c/allschoolscolleges" target="_blank"><img src="https://www.allschoolscolleges.com/youtube.png"></a><br/>

</p>

    	</td>
    </tr>

</tr>
</table>`;



//let mails= req.body["email_1"]
let mails= req.body["email_1"]
//  console.log("emailids.emailids",mails)
   
var mailOptions = {
  from: EMAIL_FROM,    // sender address
  // to: 'shani.intactadvt@gmail.com, iamsmartsunny@gmail.com', // list of receivers
  to: mails, // list of receivers
  subject: `Account Details with AllSchoolsColleges.com`, // Subject line
  // text: 'Hello world from Node.js',       // plaintext body
  html: mailcontent // html body
};
 


transporter.sendMail(mailOptions, function (error, info) {
    if (error) {
      // return res.status(500).json({
      //   success: false,
      //   message: "Email not sent",
      //   error: error,
      // });
    }
  });


  const fee = await getSinglevalueByid("application_fee","engineering_institute","e_id",req.body["college_id"]);
  let payment=''
  if(fee.application_fee>0){




let min = 1000000;
let max = 9999999;
let orderid = Math.floor(Math.random() * (max - min + 1)) + min;


// sql = `INSERT INTO buyer_order_details(BUYER_ID,PAYMENT_SOURCE,AMOUNT,ORDERID,GST) VALUES (?,?,?,?,?)`;
// result = await dbQuery(sql, [result.insertId,"Partner Student Registration Fee",fee.application_fee,orderid,""]);
// updatepays = await dbQuery(`update  sc_user set order_id='${orderid}'  where us_id=${result.insertId}`);
payment={amount:fee.application_fee,us_id:result.insertId,gst:0,source:"Partner Student Registration Fee",orderid:orderid}
       

}

  
  return res.status(200).json({
    success: true,
    message: "Account created",
    auth_token: generateToken({ us_id: result.insertId, user_type: CLG_STUDENT, college_id: collegeId, course_id: courseId,us_fname:req.body["us_fname"], partner_icon:collegelogo.institute_logo }),
    payment:payment?generateToken(payment):''
  });
});


//////////// This endpoint created for catching College Landing enquiry
const landingpagesignup = tryCatch(async (req, res) => {

  let [sql, result,collegelogo] = [null, null,[]];
  const attributes = [];
  const insertBody = [];
  collgeSignupFields.forEach((field) => {
    if (req.body[field]) {
      attributes.push(`${table}.${field}`);
      insertBody.push(req.body[field]);
    }
  });
  const requiredFields = ["email_1","us_fname","mobile_1","city","state","course", "user_type"];

  const user_type="partner"



  const missingFields = requiredFields.filter((field) => !req.body[field]);
  if (missingFields.length) {
    res.statusCode = 400;
    throw new Error(`Missing fields: ${missingFields.join(", ")}`);
  }

   collegelogo = await getSinglevalueByid("institute_logo","engineering_institute","e_id",req.body["college_id"]);

  // Check if email already exists
  // if (await checkLeadAlreadyExist(req.body["email_1"], CLG_STUDENT)){
  //   return res.status(400).json({
  //     success: false,
  //     message: "Email already exists, Please login",
  //   }); 
  // }


  if (await checkLeadAlreadyExist(req.body["email_1"], CLG_STUDENT)){
    // res.statusCode = 400;
    //throw new Error("Email already exists, Please login");

    


  const studentid = await getSinglevalueByid("us_id","sc_user","us_username",req.body["email_1"]);
  const leadShortlistDoesNotExist = await checkLeadShortlistAlreadyExist(req.body.college_id, studentid.us_id, user_type,req.body["course"]);
  

  

  if(leadShortlistDoesNotExist){
    const shortlistQuery = `INSERT INTO tbl_school_shortlist (us_id, usertype, school_id, c_id, source, date) VALUES (?, ?, ?, ?, ?, NOW())`;
    const clgShortlistResult = await dbQuery(shortlistQuery, [studentid.us_id, user_type, req.body.college_id,req.body["course"],'enq']);
    
    const commonFormQuery = `INSERT INTO tbl_common_application_form (us_id, e_id, c_id, form_status ,date) VALUES (?, ?, ?, ?, NOW())`;
    const commonFormResult = await dbQuery(commonFormQuery, [studentid.us_id, req.body.college_id,req.body["course"], "pending"]);
  }

  const username = await getSinglevalueByid("us_fname","sc_user","us_username",req.body["email_1"]);

  

  return res.status(200).json({
    success: true,
    message: "Account created",
    auth_token: generateToken({ us_id: studentid.us_id, user_type: CLG_STUDENT, us_fname:username.us_fname,partner_icon:collegelogo.institute_logo }),
    // payment:payment?generateToken(payment):''
  });

    // return res.status(400).json({
    //   success: false,
    //   message: "Email already exists",
    // });
  }


 
  let collegeId = null;
  let courseId = null;

  if(req.body["college_url"] && req.body["college_id"]){
    if(req.body["thirdpartyexist"]===false){
    const doesCollegeExist = await checkCollegeExistByUrlCourse(req.body["college_url"], req.body["course"]);
    if(!doesCollegeExist) throw new Error("College does not exist or the course, check the url");
    }
    const additionalFields = [
      `${table}.us_date_of_birth`,
      `${table}.parent_name`,
      `${table}.mother_name`,
      `${table}.caste_category`,
      `${table}.url`,
      `${table}.us_gender`,
      `${table}.country`,
      `${table}.campus`,
       
      
    ];
    
    const additionalInsertBody = [
      req.body["us_date_of_birth"],
      req.body["parent_name"],
      req.body["mother_name"],
      req.body["caste_category"],
      req.body["college_url"],
      req.body["us_gender"],
      req.body["country_code"],
      req.body["campus"],
      
      
    ]
    attributes.push(...additionalFields);
    insertBody.push(...additionalInsertBody);
    collegeId = req.body["college_id"];
    courseId = req.body["course"];
  }

 

  const requiredPreStatements = attributes.map((attr) => '?');
  sql = `INSERT INTO ${table} (${attributes.join(", ")}, us_create_date, us_username, school_college) VALUES (${requiredPreStatements.join(", ")}, NOW(), '${req.body["email_1"]}', 'college')`;
  result = await dbQuery(sql, insertBody);
  const leadId = result.insertId
  if (!result.affectedRows) throw new Error("Unable to create account");
  const leadDocResult = await dbQuery(`INSERT INTO ${leadDocTbl} (us_id) VALUES (?)`, [result.insertId]);
  if(!leadDocResult.affectedRows) {
    const deleteLeadSql = `DELETE FROM ${table} WHERE us_id = ?`;
    const delLeadResult = await dbQuery(deleteLeadSql,[leadId])
    throw new Error("Unable to create documents, please try again");
  }
 
const cityname = await getSinglevalueByid("cname","city_tbl","ctid",req.body["city"]);
const statename = await getSinglevalueByid("state","state_tbl","sid",req.body["state"]);
const collegename = await getSinglevalueByid("institute_name","engineering_institute","e_id",req.body["college_id"]);

let newcourse=null;
let newspecialization=null;




if(isNaN(req.body["course"])===false){


  const course = await getSinglevalueByid("course_name","engineering_institute_course","c_id",req.body["course"]);
  const specialization = await getSinglevalueByid("specialization","engineering_institute_course","c_id",req.body["course"]);

  newcourse=course.course_name;
  newspecialization=specialization.specialization;
 
}
else
{
 
  let campus=req.body["campus"]?req.body["campus"]+" ":"";
  newcourse=campus+"["+req.body["course"]+"]";
  newspecialization=req.body["specialization"];
  
}





let firstname=req.body["us_fname"];
let lastname= req.body["us_lname"]?" "+req.body["us_lname"]:'' ;

const insertvalue={
  name:firstname+lastname, 
  email:req.body["email_1"], 
  country_code:"+91", 
  mobile:req.body["mobile_1"], 
  state:statename.state, 
  city:cityname.cname, 
  college_name:collegename.institute_name, 
  castecategory:req.body["caste_category"], 
  father:req.body["parent_name"], 
  course:newcourse, 
  specialization:newspecialization,
  insertid:leadId,
  neetscore:""
}



/////////////// Lead push on openapply portal
const updateval={updatecol:"npf_response",table:"sc_user",updatekey:"us_id",updateid:leadId,college_id:req.body["college_id"]}
const resptd= openapply.addopenapply(insertvalue,updateval);

/////////////// Lead push on third party api's
const tpi= thirdpartyapi.addtonpf(updateval,req.body,req.body) 





const fee = await getSinglevalueByid("application_fee","engineering_institute","e_id",req.body["college_id"]);
let payment=''
if(fee.application_fee>0){
let min = 1000000;
let max = 9999999;
let orderid = Math.floor(Math.random() * (max - min + 1)) + min;
payment={amount:fee.application_fee,us_id:result.insertId,gst:0,source:"Partner Student Registration Fee",orderid:orderid}
     

}

 



  return res.status(200).json({
    success: true,
    message: "Account created",
    auth_token: generateToken({ us_id: result.insertId, user_type: CLG_STUDENT, college_id: collegeId, course_id: courseId, partner_icon:collegelogo.institute_logo }),
    payment:payment?generateToken(payment):''
  });

})


module.exports = { signup,landingpagesignup  };
