const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const {
  errorMsgAuth,
  errorMsgEmpty,
} = require("../../../../utils/errors_message");
const { TBL_SCHOOL_STUDENT } = require("../../../../models/tables");
const updateColumn = require("../../../../utils/updateColumn");
const { checkChildAlreadyExist } = require("../../../../utils/leadAccessCheck");
const { filterRequiredFields, exportFieldsName } = require("../../requiredFieldsForUpdate.util");

const table = TBL_SCHOOL_STUDENT;

// @desc get only one child details by id
// @route GET /api/v1/student/child-common-form
// @access Private STUDENT
const get_childCommonApplicationForm = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id } = req.lead;
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  const { id } = req.params;
  if (!id) errorMsgEmpty("No child found without id", res);
  sql = `SELECT * FROM ${table} WHERE id = ? AND us_id = ? LIMIT 1`;
  result = await dbQuery(sql, [id, us_id]);
  if (!result.length) errorMsgEmpty("No child found", res);
  res.status(200).json({
    success: true,
    data: result[0],
  });
});

// @desc update only one child details by id
// @route PUT /api/v1/student/child-common-form/:id
// @access Private STUDENT
const put_childCommonApplicationForm = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const [{ us_id }, { id }] = [req.lead, req.params];
  if (!us_id) errorMsgAuth("Unauthorized access", res);
  if (!id) errorMsgEmpty("No child found without id", res);
  const doesChildExist = await checkChildAlreadyExist(id, us_id);
  if (!doesChildExist) {
    throw new Error("No child found, with this id");
  }
  const { update } = req.body;
  if (!update) throw new Error("Please fill all the fields");

const { fieldsForChildCommonForm } = exportFieldsName;
const requiredFieldsObj = filterRequiredFields(update, fieldsForChildCommonForm);
  const { column, value } = updateColumn(requiredFieldsObj);
  sql = `UPDATE ${table} SET ${column} WHERE id = ? AND us_id = ?`;
  result = await dbQuery(sql, [...value, id, us_id]);
  if (!result.affectedRows) throw new Error("No child updated");
  res.status(200).json({
    success: true,
    message: "Child updated successfully",
  });
});

module.exports = {
  get_childCommonApplicationForm,
  put_childCommonApplicationForm,
};
