const { dbQuery } = require("../../../../config/db.config");
const tryCatch = require("../../../../utils/tryCatch");
const {
  errorMsgAuth,
  errorMsgEmpty,
} = require("../../../../utils/errors_message");
const { SCHOOL_DETAIL } = require("../../../../models/tables");

const table = SCHOOL_DETAIL;

// @desc get all partner school
// @route GET /api/v1/student/partner-school
// @access Private STUDENTS
const getParnetSchool = tryCatch(async (req, res) => {
  let [sql, result] = [null, null];
  const { us_id, user_type } = req.lead;
  const { search } = req.query;

  let qry = "";
  if (search) {
    qry += ` AND (school_name LIKE '%${search}%' OR city LIKE '%${search}%' OR state LIKE '%${search}%')`;
  }

  if (!us_id || !user_type) errorMsgAuth("Unauthorized access", res);
  const attributes = [
    `${table}.sid`,
    `${table}.school_name`,
    `${table}.school_url`,
    `${table}.school_logo`,
    `${table}.city`,
    `${table}.state`,
  ];
  sql = `SELECT ${attributes.join(", ")}  FROM ${table} WHERE 1=1 AND admission_partner = ?` + qry;
  result = await dbQuery(sql, "Y");
  if (result.length === 0) errorMsgEmpty("No school found", res);
  return res.status(200).json({ success: true, data: result });
});

module.exports = {
  getParnetSchool,
};
