const { dbQuery } = require("../../config/db.config");
const tryCatch = require("../../utils/tryCatch");
const {
  SC_USER,
  PARTNER_STUDENT_DOC,
  C_INSTITUTE,
  C_COURSE,
  CMS_ADMIN,
} = require("../../models/tables");
const {
  BUYER,
  CLG_STUDENT,
  SCL_STUDENT,
  ADMIN,
} = require("../../common/constants");

const leadTbl = SC_USER;
const leadClgDocTbl = PARTNER_STUDENT_DOC;
const clgTbl = C_INSTITUTE;
const clgCourseTbl = C_COURSE;
const adminTbl = CMS_ADMIN;

const getCollgeIdOnCourseId = async (id) => {
  const leadSql = `SELECT ${leadTbl}.course FROM ${leadTbl} WHERE ${leadTbl}.us_id = ? LIMIT 1`;
  const leadResult = await dbQuery(leadSql, [id]);
  const courseId = leadResult[0].course;
  const clgCourseSql = `SELECT ${clgCourseTbl}.e_id FROM ${clgCourseTbl} WHERE ${clgCourseTbl}.c_id = ? LIMIT 1`;
  const clgCourseResult = await dbQuery(clgCourseSql, [courseId]);
  if(!clgCourseResult.length) return null;
  return clgCourseResult[0].e_id; // college id
};

const getLeadBasicDetails = async (id, type) => {
  let [sql, result] = [null, null];
  let joinTbl = "";
  let attributes = [
    `${leadTbl}.us_fname`,
    `${leadTbl}.email_1`,
    `${leadTbl}.mobile_1`,
    `${leadTbl}.user_type`,
    `${leadTbl}.us_username`,
  ];

  switch (type) {
    case CLG_STUDENT:
      attributes.push(...[`${leadClgDocTbl}.profile_pic`]);
      joinTbl = `LEFT JOIN ${leadClgDocTbl} ON ${leadTbl}.us_id = ${leadClgDocTbl}.us_id`;
      sql = `SELECT ${attributes.join(", ")} FROM ${leadTbl} ${joinTbl} WHERE ${leadTbl}.us_id = ? LIMIT 1`;
      break;
    case BUYER:
      attributes.push(
        ...[
          `${leadTbl}.export_data`,
          `${leadTbl}.subscription_date`,
          `${leadTbl}.renewal_date`,
        ]
      );
      sql = `SELECT ${attributes.join(",")}FROM ${leadTbl} WHERE ${leadTbl}.us_id = ? LIMIT 1`;
      break;
    case SCL_STUDENT:
      attributes.push(...[`${leadTbl}.url`]);
      sql = `SELECT ${attributes.join(",")} FROM ${leadTbl} WHERE ${leadTbl}.us_id = ? LIMIT 1`;
      break;

    // case ADMIN:
    //   attributes = [
    //     `${adminTbl}.id`,
    //     `${adminTbl}.user`,
    //     `${adminTbl}.admin_type`,
    //   ]
    //   sql = `SELECT ${attributes.join(",")} FROM ${adminTbl} WHERE ${adminTbl}.id = ? LIMIT 1`;
    default:
      throw new Error("Invalid user type");
  }
  result = await dbQuery(sql, [id]);
  return result[0];
};

// @desc Get LEAD basic info
// @route GET /api/v1/student/lead-details
// @access Private
const getLeadBasicInfo = tryCatch(async (req, res) => {
  const { us_id: id, user_type: type } = req.lead;
  if (!id || !type) throw new Error("Unauthorized access");

  const leadDetails = await getLeadBasicDetails(id, type);

  return res.status(200).json({
    success: true,
    data: leadDetails,
  });
});

module.exports = {
  getLeadBasicInfo,
  getCollgeIdOnCourseId,
  getLeadBasicDetails,
};
