// Schools Requried Fields for Update
const fieldsForManagingChild = [
  "full_name",
  "gender",
  "std", // class to admit
  "dob",
];

const fieldsForChildCommonForm = [
  "full_name",
  "gender",
  "std",
  "dob",
  "blood_group",
  "mother_tongue",
  "religion",
  "category",
  "child_disability",
  "disability_type",
  "par_name",
  "par_con",
  "par_email",
  "par_quali",
  "par_occup",
  "par_annual_income",
  "mother_name",
  "corr_housne_no",
  "corr_locality",
  "corr_state",
  "corr_dist",
  "corr_city",
  "corr_pin",
  "mother_con",
  "child_photo",
  "child_birth_certificate",
  "child_aadhar_no",
  "child_aadhar_card",
  "child_address_type",
  "child_address_doc",
  "father_photo",
  "father_aadhar_no",
  "father_aadhar_doc",
  "mother_photo",
  "mother_aadhar_no",
  "mother_aadhar_doc",
  "current_step",
  "active",
  "date",
  "form_status",
];

const fieldsForLeadsProfile = [
  "us_fname",
  "us_lname",
  "alternate_number",
  "state",
  "district",
  "city",
  "course",
];

const fieldsForCollegeBankDetails = [
  "bank_ac_holder",
  "bank_name",
  "bank_ac",
  "bank_ifsc",
  "upi",
];

const fieldsForShortlistForm = [
  "id",
  "e_id",
  "c_id",
  "name",
  "email",
  "mobile",
  "gender",
  "parent_mobile",
  "country",
  "state",
  "city",
  "dob",
  "caste",
  "mother_tongue",
  "passing_year_10",
  "school_name_10",
  "board_10",
  "evaluation_10",
  "percentage_10",
  "passing_year_12",
  "school_name_12",
  "board_12",
  "percentage_12",
  "stream_12",
  "result_status_12",
  "have_gradut",
  "passing_gradut",
  "college_gradut",
  "university_gradut",
  "study_mode_gradut",
  "exam_type_gradut",
  "specialization_gradut",
  "degree_gradut",
  "accomodation_require",
  "accomodation_type",
  "any_entrance",
  "entrance_type",
  "entrance_score",
  "current_step",
];

const fieldsForApplicationForm = [
  "us_fname",
  "us_lname",
  "email_1",
  "mobile_1",
  "alternate_number",
  "us_date_of_birth",
  "course",
  "us_gender",
  "student_aadhar_no",
  "student_passport_no",
  "caste_category",
  "blood_group",
  "mother_tongue",
  "state",
  "district",
  "city",
  "address",
  "zip",
  "parent_name",
  "mother_name",
  "parent_email",
  "parent_mobile",
  "father_occup",
  "institute_name_10",
  "board_ten",
  "passing_ten",
  "evaluation_10",
  "percentage_ten",
  "institute_name_12",
  "board",
  "passing_12",
  "stream_12",
  "result_status_12",
  "evaluation_12",
  "percenage_board",
  "institute_name_diploma",
  "diploma_university",
  "diploma_passing",
  "result_status_diploma",
  "evaluation_diploma",
  "percentage_diploma",
  "have_graduation",
  "degree_name",
  "college_name",
  "university_name",
  "graduat_passing",
  "graduation_marks",
  "grad_mode_of_study",
  "grad_exam_type",
  "grad_area_specl",
  "accomodation_req",
  "accomodation_type",
  "entrance_type",
  "religion",
  "entrance_score",
];

const objContainingAllRequiredFields = {
  fieldsForManagingChild,
  fieldsForChildCommonForm,
  fieldsForLeadsProfile,
  fieldsForCollegeBankDetails,
  fieldsForShortlistForm,
  fieldsForApplicationForm,
};

const exportFieldsName = {
  fieldsForManagingChild: "fieldsForManagingChild",
  fieldsForChildCommonForm: "fieldsForChildCommonForm",
  fieldsForLeadsProfile: "fieldsForLeadsProfile",
  fieldsForCollegeBankDetails: "fieldsForCollegeBankDetails",
  fieldsForShortlistForm: "fieldsForShortlistForm",
  fieldsForApplicationForm: "fieldsForApplicationForm",
};

const filterRequiredFields = (update, requiredFields) => {
  const requiredFieldsObj = {};
  const requiredFieldsFromObject =
    objContainingAllRequiredFields[requiredFields];
  Object.keys(update).forEach((key) => {
    if (requiredFieldsFromObject.includes(key)) {
      requiredFieldsObj[key] = update[key];
    }
  });
  if (Object.keys(requiredFieldsObj).length === 0)
    throw new Error("No required field to update");

  return requiredFieldsObj;
};

module.exports = { filterRequiredFields, exportFieldsName };
