const jwt = require("jsonwebtoken");

const protect = async (req, res, next) => {
  let token;
  if (
    req.headers.authorization &&
    req.headers.authorization.startsWith("Bearer")
  ) {
    try {
      token = req.headers.authorization.split(" ")[1];

      // Verfiy Token
      const decoded = jwt.verify(token, process.env.JWT_SECRET);

      // Getting the Admin Type
      const { admin_type, id } = decoded.admin;
      req.role = admin_type;
      req.adminId = id;

    } catch (error) {
      console.log(error);
      return res
        .status(401)
        .json({ message: "Not authorized, token failed" })
        .end();
    }
  }
  if (!token) {
    return res.status(401).json({ message: "Not authorized, no token" }).end();
  }
  next();
};

module.exports = protect;
