const NodeCache = require("node-cache");
const hash = require("object-hash");
const serverCache = new NodeCache({ maxKeys: 1000 });

module.exports = (duration) => (req, res, next) => {
  console.log("calling -->", req.originalUrl, req.method.toUpperCase());
  if(doNotCacheThisRoute(req.originalUrl)){
    console.log("NO CACHE ACCESS FOR THIS ROUTE")
    return next();
  }
  
  const key = createUrlHashKey(req.originalUrl, req.lead?.us_id || "");

  if (req.method !== "GET") {
    if(req.originalUrl.includes("/admin/")){
      console.log("🚽 FLUSHED ALL CACHED DATA 🚽");
      serverCache.flushAll();
    }
    if (serverCache.has(key)) {
      console.log("DELETED CACHE FOR", req.originalUrl);
      serverCache.del(key); // Clear cache on POST, PUT, DELETE
    }
    return next();
  }
  const cachedBody = serverCache.get(key);
  if (cachedBody) {
    console.log("💾 GETTING DATA FROM CACHE 💾")
    // Send json response
    res.json(JSON.parse(cachedBody));
  } else {
    // Send response
    console.log("🗃️ FETCHING DATA FROM DB 🗃️")
    res.sendResponse = res.send;
    res.send = (body) => {
      serverCache.set(key, body, duration);
      res.sendResponse(body);
    };
  next();
  }
};

const createUrlHashKey = (url, leadId) => {
  if(url.includes("/student/")){
    return hash.MD5({ url, leadId });
  }
  return hash.MD5({ url });
};

const doNotCacheThisRoute = (url) => {
  const sanitizedUrl = url.split("?")[0]
  const notCachedRoutes = {
    "/api/v1/admin/enquiry/exam": true,
    "/api/v1/admin/enquiry/career": true,
    "/api/v1/admin/enquiry/career-footer": true,
    "/api/v1/admin/enquiry/partner-enquiry": true,
    "/api/v1/admin/enquiry/studyindia": true,
    "/api/v1/admin/enquiry/student": true,
    "/api/v1/admin/enquiry/admission/school": true,
    "/api/v1/student/school-dashboard": true,
  }
  return notCachedRoutes[sanitizedUrl];
}
