const errorHandler = (err, req, res, next) => {
  const statusCode = res.statusCode !== 200 ? res.statusCode : 500;
  if (statusCode === 201) {
    res.status(200).json({
      success: true,
      data: [],
      records: 0,
      message: err.message || "No Data Found",
    });
  } else {
    res.status(statusCode).json({
      message: err.message || "Something went wrong",
      stack: process.env.NODE_ENV === "development" ? err.stack : undefined,
    });
  }
};

module.exports = { errorHandler };
