const jwt = require("jsonwebtoken");
const { checkLeadExistInDatabase } = require("../utils/leadAccessCheck");

const protectLead = async (req, res, next) => {
  let token;
  if (
    req.headers.authorization &&
    req.headers.authorization.startsWith("Bearer")
  ) {
    try {
      token = req.headers.authorization.split(" ")[1];

      // Verfiy Token
      const decoded = jwt.verify(token, process.env.STUDENT_JWT_SECRET);

      // Getting the STUDENT Id & USER_TPYE
      req.lead = decoded.user; //{us_id: 1, user_type: "student"}
      req.role = decoded.user.user_type
      const doesLeadExist = await checkLeadExistInDatabase(req.lead.us_id);
      if (!doesLeadExist) {
        return res
          .status(401)
          .json({ message: "Not authorized, Who are you?"})
          .end();
      }

    } catch (error) {
      console.log(error);
      return res
        .status(401)
        .json({ message: "Not authorized, token failed" })
        .end();
    }
  }
  if (!token) {
    return res.status(401).json({ message: "Not authorized, no token " }).end();
  }
  next();
};

module.exports = protectLead;