const { hasRouteAccess } = require("../routes/role_route_mapper");

const roleRouteAccess = async (req, res, next) => {
  try {
    const path = sanitizeRequestRoute(req.originalUrl);
    const response = hasRouteAccess(req.method, path, req.role);
    if (!response.routeAccess) {
      return res.status(response.status).json({
        code: response.code,
        message: response.message,
      });
    }
  } catch (error) {
    console.log(error);
    res.status(500).json({
      code: "INTERNAL SERVER ERROR",
      message: `An internal server error occured. \n ${error.message}`,
    });
  }
  next();
};

const sanitizeRequestRoute = (route) => {
  let path = route.split("?")[0];
  path = path.replace('/api/v1', "");
  path = path.split("/");
  const finalPath = [];

  path.forEach((p) => {
    if (p === "") return;
    if (!isNaN(Number(p))) {
      // replaces dynamic ids in request url with "*".
      finalPath.push("*");
    } else {
      finalPath.push(p);
    }
  });
  path = "/" + finalPath.join("/");
  return path;
};

module.exports = roleRouteAccess;
