const tryCatch = require("../utils/tryCatch");
const { dbQuery } = require("../config/db.config");
const axios = require("axios");
const {
  OpenApplyResponseUpdate,
  getSinglevalueByid,
} = require("../utils/leadAccessCheck");
const { TBL_NPF_API } = require("../models/tables");
const { getnpfCredentials } = require("../services/college.service");

const addtonpf = tryCatch(async (updateval, data) => {
  const queryfornpfAPI = {
    attributes: [
      `${TBL_NPF_API}.eid`,
      `${TBL_NPF_API}.college_id`,
      `${TBL_NPF_API}.api`,
      `${TBL_NPF_API}.secret_key`,
      `${TBL_NPF_API}.source`,
      `${TBL_NPF_API}.api_name`,
    ],
    conditions: [`${TBL_NPF_API}.eid = ?`, `${TBL_NPF_API}.active = 'Y'`],
    parameters: [updateval.college_id],
  };
  const apidata = await getnpfCredentials(queryfornpfAPI);

  let api = apidata[0].api;
  let secret_key = apidata[0].secret_key;
  let source = apidata[0].source;
  let college_id = apidata[0].college_id;
  let api_name = apidata[0].api_name;

  const cityname = await getSinglevalueByid(
    "cname",
    "city_tbl",
    "ctid",
    data.city
  );
  const statename = await getSinglevalueByid(
    "state",
    "state_tbl",
    "sid",
    data.state
  );

  if(api_name=='npf'){
       postData = {
        "college_id" : college_id,
        "secret_key" : secret_key,
        "source" : source,
        "name" : data.us_fname,
        "email" :data.email_1,
        "mobile" : data.mobile_1,
        "state" : statename.state,
        "city" :  cityname.cname,
        "campus" : data.campus,
        "course" : data.course,
        "specialization" :data.specialization,
      };
    }

  // if(api_name=='Okie Dokie Admission')
  // {}

  // let postData =  {

  // 	"entity" : secret_key,
  // 	"session" : "2024-25 Odd",
  // 	"course" : data.course,
  // 	"stream" : data.course ,
  // 	"batch" : "Sem 1",
  // 	"autoApplicationNumber" : true,
  // 	"allApplicationNumber" : true,
  // 	"currentStage" : "Lead",
  // 	"sourceId" : "1",
  // 	"source" : source,
  // 	"name" : data.us_fname,
  // 	"phone" : data.mobile_1,
  // 	"email" : data.email_1,
  // 	"dob" : "",
  // 	"fatherName" : "",
  // 	"gender" : "",
  // 	"address" : "",
  // 	"city" : cityname.cname,
  // 	"state" : statename.state,
  // 	"country" : "India",
  // 	"pinCode" : "000000"
  // };

  //  let postData = {
  //           "college_id" : college_id,
  //           "secret_key" : secret_key,
  //           "source" : source,
  //           "name" : data.us_fname,
  //           "email" :data.email_1,
  //           "mobile" : data.mobile_1,
  //           "state" : statename.state,
  //           "city" :  cityname.cname,
  //           "campus" : data.campus,
  //           "course" : data.course,
  //           "specialization" :data.specialization,
  //         };

  // let postData = {
  //   entity: "6608ec3120337200120f347e",
  //   session: "2024-25 Odd",
  //   course: "School of Arts Humanities and Social Sciences",
  //   stream: "B.A (Hons.) in English",
  //   batch: "Sem 1",
  //   autoApplicationNumber: true,
  //   allApplicationNumber: true,
  //   currentStage: "Lead",
  //   sourceId: "47525",
  //   source: "Intact",
  //   name: "test usnder",
  //   phone: "8835475478",
  //   email: "kalksssksssas@gmail.com",
  //   dob: "",
  //   fatherName: "",
  //   gender: "",
  //   address: "",
  //   city: "Agra",
  //   state: "Uttar Pradesh",
  //   country: "India",
  //   pinCode: "000000",
  // };

  axios.post(`${api}`, postData).then((response) => {
    console.log("response", response.data);
    // return response
    // console.log('Response:', response.data.msg);
    // let msg =response.data.msg;

    ////Below function use for updating response which is  receive from OPen apply apps
    const openupdate = OpenApplyResponseUpdate(
      updateval.updatecol,
      updateval.table,
      updateval.updatekey,
      updateval.updateid,
      response.data
    );
  });
});

module.exports = { addtonpf };
