const express = require("express");
const adminRouter = express.Router();
const masterCnt = require("../controllers/admin/master");
const cmsCnt = require("../controllers/admin/CMS");
const {
  upload,
  uploadFilesToS3Bucket,
  deleteFilesFromS3Bucket,
} = require("../aws/uploadFiles.aws");
const serverCache = require("../middlewares/CacheRoute.middleware");

//---------------- @desc MASTER ROUTES CRUD ----------------
const [
  locationMaster,
  categoryMaster,
  schoolTypeMaster,
  collegeTypeMaster,
  schoolFacilityMaster,
  levelMaster,
  costOfStudyMaster,
  courseDeliveryMaster,
  companyPlacementMaster,
  courseMaster,
  scFacilitiesMaster,
  specializationMaster,
  examLevelMaster,
  thirdPartyAPI,
] = [
  masterCnt.locationController,
  masterCnt.categoryController,
  masterCnt.schoolTypeController,
  masterCnt.collegeTypeController,
  masterCnt.schoolFacilityController,
  masterCnt.levelController,
  masterCnt.costOfStudyController,
  masterCnt.courseDeliveryController,
  masterCnt.companyPlacementController,
  masterCnt.courseController,
  masterCnt.scFacilitiesController,
  masterCnt.specializationController,
  masterCnt.examLevelController,
  masterCnt.thirdPartyAPI,
];
// Locations
adminRouter.route("/location/:loc").get(locationMaster.get_master);

// Category
adminRouter
  .route("/category")
  .get(categoryMaster.get_category)
  .post(categoryMaster.post_category)
  .put(categoryMaster.update_category)
  .delete(categoryMaster.del_category);

// School Type
adminRouter
  .route("/schooltype")
  .get(schoolTypeMaster.get_schoolType)
  .post(schoolTypeMaster.post_schoolType)
  .put(schoolTypeMaster.update_schoolType)
  .delete(schoolTypeMaster.del_schoolType);

// College Type
adminRouter
  .route("/collegetype")
  .get(collegeTypeMaster.get_collegeType)
  .post(collegeTypeMaster.post_collegeType)
  .put(collegeTypeMaster.update_collegeType)
  .delete(collegeTypeMaster.del_collegeType);

// School Facility
adminRouter
  .route("/schoolfacility")
  .get(schoolFacilityMaster.get_schoolFacility)
  .post(schoolFacilityMaster.post_schoolFacility)
  .put(schoolFacilityMaster.update_schoolFacility)
  .delete(schoolFacilityMaster.del_schoolFacility);

// Course Level
adminRouter
  .route("/course-level")
  .get(levelMaster.get_level)
  .post(levelMaster.post_level)
  .put(levelMaster.update_level)
  .delete(levelMaster.del_level);

// Cost of Study
adminRouter
  .route("/cost-of-study")
  .get(costOfStudyMaster.get_costOfStudy)
  .post(costOfStudyMaster.post_costOfStudy)
  .put(costOfStudyMaster.update_costOfStudy)
  .delete(costOfStudyMaster.del_costOfStudy);

// Course Delivery
adminRouter
  .route("/course-delivery")
  .get(courseDeliveryMaster.get_courseDelivery)
  .post(courseDeliveryMaster.post_courseDelivery)
  .put(courseDeliveryMaster.update_courseDelivery)
  .delete(courseDeliveryMaster.del_courseDelivery);

// Company Placement
adminRouter
  .route("/company-placement")
  .get(companyPlacementMaster.get_companyPlacement)
  .post(companyPlacementMaster.post_companyPlacement)
  .put(companyPlacementMaster.update_companyPlacement)
  .delete(companyPlacementMaster.del_companyPlacement);

// Course
adminRouter
  .route("/course")
  .get(courseMaster.get_course)
  .post(courseMaster.post_course)
  .put(courseMaster.update_course)
  .delete(courseMaster.del_course);

// SC Facilities
adminRouter
  .route("/sc-facilities")
  .get(scFacilitiesMaster.get_scFacilities)
  .post(scFacilitiesMaster.post_scFacilities)
  .put(scFacilitiesMaster.update_scFacilities)
  .delete(scFacilitiesMaster.del_scFacilities);

// Specialization
adminRouter
  .route("/specialization")
  .get(specializationMaster.get_specialization)
  .post(specializationMaster.post_specialization)
  .put(specializationMaster.update_specialization)
  .delete(specializationMaster.del_specialization);

// Exam Level
adminRouter
  .route("/exam-level")
  .get(examLevelMaster.get_examLevel)
  .post(examLevelMaster.post_examLevel)
  .put(examLevelMaster.update_examLevel)
  .delete(examLevelMaster.del_examLevel);


  adminRouter
  .route("/third-party-api")
  // .get(thirdPartyAPI.get_APi_list)
  .post(thirdPartyAPI.post_tpi)
  // .put(examLevelMaster.update_examLevel)
  // .delete(examLevelMaster.del_examLevel);

  adminRouter
  .route("/get-third-party-services")
  .get(thirdPartyAPI.get_APi_list)

  adminRouter
  .route("/get-third-party-courses")
  .get(thirdPartyAPI.get_APi_Courselist)

  adminRouter
  .route("/add-menual-student-entry")
  .post(thirdPartyAPI.post_add_menual_student)

  adminRouter
  .route("/npf-leads")
  .get(thirdPartyAPI.npf_leads)

  adminRouter
  .route("/npf-leads/:tbl")
  .get(thirdPartyAPI.get_APi_list_individual)
  

//---------------- @desc CMS ROUTES CRUD ----------------

const [
  schoolDetailsCMS,
  examListCMS,
  careerCMS,
  collegeCMS,
  collegeMediaCMS,
  collegeCourseCMS,
  collegeContactCMS,
  collegeAdditionalCMS,
  collegePlacementCMS,
  schoolLocationCMS,
  schoolCityCMS,
  collegeCityCMS,
  articleCategoryCMS,
  articlesCMS,
  schoolContentCMS,
  collegeContentCMS,
  tblAccordionCMS,
  footerEnquiryCMS,
  careerEnquiryCMS,
  buyerEnquiryCMS,
  examEnquiryCMS,
  schoolEnquiryCMS,
  studentEnquiryCMS,
  emailTempCMS,
  schoolPartnerCMS,
  schoolGradeFees,
  schoolAwards,
  schoolFaq,
  Users
] = [
  cmsCnt.schoolDetailsController,
  cmsCnt.examListController,
  cmsCnt.careerController,
  cmsCnt.collegeDetailsController,
  cmsCnt.collegeMediaController,
  cmsCnt.collegeCourseController,
  cmsCnt.collegeContactController,
  cmsCnt.collegeAdditionalController,
  cmsCnt.collegePlacementController,
  cmsCnt.schoolLocationController,
  cmsCnt.schoolCityController,
  cmsCnt.collegeCityController,
  cmsCnt.articleCategoryController,
  cmsCnt.articlesController,
  cmsCnt.schoolContentController,
  cmsCnt.collegeContentController,
  cmsCnt.tblAccordionController,
  cmsCnt.footerEnquiryController,
  cmsCnt.careerEnquiryController,
  cmsCnt.buyerEnquiryController,
  cmsCnt.examEnquiryController,
  cmsCnt.schoolEnquiryController,
  cmsCnt.studentEnquiryController,
  cmsCnt.emailTemplateController,
  cmsCnt.becomeSchoolPartnerController,
  cmsCnt.schoolGradeFeesController,
  cmsCnt.schoolAwardsController,
  cmsCnt.schoolFAQController,
  cmsCnt.Users
];

// School Details
adminRouter
  .route("/school-details")
  .get(schoolDetailsCMS.get_schoolDetails)
  .post(schoolDetailsCMS.post_schoolDetails)
  // .put(schoolDetailsCMS.update_schoolDetails)
  // .delete(schoolDetailsCMS.del_schoolDetails);

// One school Details
adminRouter
  .route("/school-details/:sid") // sid = school id.
  .get(schoolDetailsCMS.getSchoolDetailsById)
  .put(schoolDetailsCMS.updateSchoolDetailsById)
  .delete(schoolDetailsCMS.deleteSchoolDetailsById);

// School Grade Fees
adminRouter
  .route("/grade-fees/:sid") // sid = school id.
  .get(schoolGradeFees.getSchoolGradeFees)
  .post(schoolGradeFees.addSchoolGradeFees);

// School Location
adminRouter
  .route("/school-location")
  .get(schoolLocationCMS.get_schoolLocation)
  .post(schoolLocationCMS.post_schoolLocation)
  .put(schoolLocationCMS.update_schoolLocation)
  .delete(schoolLocationCMS.del_schoolLocation);

// School City
adminRouter
  .route("/school-city")
  .get(schoolCityCMS.get_schoolCity)
  .post(schoolCityCMS.post_schoolCity)
  .put(schoolCityCMS.update_schoolCity)
  .delete(schoolCityCMS.del_schoolCity);

// School | college Awards
adminRouter
  .route("/awards/:sid") // sid = school id.
  .get(schoolAwards.getSchoolAwards)
  .post(schoolAwards.postSchoolAwards)
  .put(schoolAwards.updateSchoolAwards)
  .delete(schoolAwards.deleteSchoolAwards);

// School | college FAQ
adminRouter
  .route("/faq/:sid") // sid = school id.
  .get(schoolFaq.getSchoolFAQ)
  .post(schoolFaq.addSchoolFAQ)
  .put(schoolFaq.updateSchoolFAQ)
  .delete(schoolFaq.deleteSchoolFAQ);

// Exam List
adminRouter
  .route("/exam-list")
  .get(examListCMS.get_examList)
  .post(examListCMS.post_examList)
  .put(examListCMS.update_examList)
  .delete(examListCMS.del_examList);

// Career
adminRouter
  .route("/career")
  .get(careerCMS.get_careerList)
  .post(careerCMS.post_careerList)
  .put(careerCMS.update_careerList)
  .delete(careerCMS.del_careerList);

// College Details
adminRouter
  .route("/college-details")
  .get(collegeCMS.get_collegeDetails)
  .post(collegeCMS.post_collegeDetails)


  // Custom search created for admin use where user can find college on behalf on courses and category
  adminRouter
  .route("/college-details/custom")
  .get(collegeCMS.getCollegeforAdminSearch)

  
  
  // get one college details
  adminRouter
  .route("/college-details/:e_id") // eid = college id.
  .get(collegeCMS.getCollegeDetailsById)
  .put(collegeCMS.updateCollegeDetailsById)
  .delete(collegeCMS.deleteCollegeDetailsById);

// College Media :e_id
adminRouter
  .route("/college-media/:e_id")
  .get(collegeMediaCMS.get_collegeMedia)
  .post(collegeMediaCMS.post_collegeMedia)
  .put(collegeMediaCMS.update_collegeMedia)
  .delete(collegeMediaCMS.del_collegeMedia);

// College Course: e_id
adminRouter
  .route("/college-course/:e_id")
  .get(collegeCourseCMS.get_collegeCourse)
  .post(collegeCourseCMS.post_collegeCourse)
  .put(collegeCourseCMS.update_collegeCourse)
  .delete(collegeCourseCMS.del_collegeCourse);

// College Contact: e_id
adminRouter
  .route("/college-contact/:e_id")
  .get(collegeContactCMS.get_collegeContact)
  .post(collegeContactCMS.post_collegeContact)
  .put(collegeContactCMS.update_collegeContact)
  .delete(collegeContactCMS.del_collegeContact);

// College Additional: e_id
adminRouter
  .route("/college-additional/:e_id")
  .get(collegeAdditionalCMS.get_additionalDetails)
  .post(collegeAdditionalCMS.post_additonalDetails)
  .put(collegeAdditionalCMS.update_additionalDetails)
  .delete(collegeAdditionalCMS.del_additionalDetails);

// College Placment
adminRouter
  .route("/college-placement/:e_id")
  .get(collegePlacementCMS.get_placementDetails)
  .put(collegePlacementCMS.update_placementDetails);

// College City
adminRouter
  .route("/college-city")
  .get(collegeCityCMS.get_collegeCity)
  .post(collegeCityCMS.post_collegeCity)
  .put(collegeCityCMS.update_collegeCity)
  .delete(collegeCityCMS.del_collegeCity);

// College Content
adminRouter
  .route("/college-content")
  .get(collegeContentCMS.get_collegeContent)
  .post(collegeContentCMS.post_collegeContent)
  .put(collegeContentCMS.update_collegeContent)
  .delete(collegeContentCMS.del_collegeContent);

// Tbl Accordion Content
adminRouter
  .route("/accordion-content")
  .get(tblAccordionCMS.get_accordionContent)
  .post(tblAccordionCMS.post_accordionContent)
  .put(tblAccordionCMS.update_accordion_Content)
  .delete(tblAccordionCMS.del_accordionContent);
  

// Article Category
adminRouter
  .route("/article-category")
  .get(articleCategoryCMS.get_articleCategory)
  .post(articleCategoryCMS.post_articleCategory)
  .put(articleCategoryCMS.update_articleCategory)
  .delete(articleCategoryCMS.del_articleCategory);

// Articles
adminRouter
  .route("/articles")
  .get(articlesCMS.get_articles)
  .post(articlesCMS.post_articles)
  .put(articlesCMS.update_articles)
  .delete(articlesCMS.del_articles);

// Content School
adminRouter
  .route("/school-content")
  .get(schoolContentCMS.get_schoolContent)
  .post(schoolContentCMS.post_schoolContent)
  .put(schoolContentCMS.update_schoolContent)
  .delete(schoolContentCMS.del_schoolContent);

// Footer Career Enquiry
adminRouter
  .route("/enquiry/career-footer")
  .get(footerEnquiryCMS.get_footerEnquiry)
  .delete(footerEnquiryCMS.del_footerEnquiry);

// Career Enquiry
adminRouter
  .route("/enquiry/career")
  .get(careerEnquiryCMS.get_freelyEnquiry);

adminRouter
  .route("/enquiry/career/:id")
  .get(careerEnquiryCMS.getFreelyEnquiryDetails)
  .put(careerEnquiryCMS.update_freelyEnquiry)
  .delete(careerEnquiryCMS.del_freelyEnquiry);

adminRouter
  .route("/enquiry/career/mails")
  .post(careerEnquiryCMS.sendBulkEmailsToCareerEnquiry);

// Buyer Enquiry
adminRouter
  .route("/enquiry/partner-enquiry")
  .get(buyerEnquiryCMS.get_partnerEnquiry)
  .delete(buyerEnquiryCMS.del_partnerEnquiry);

// Exam Enquiry
adminRouter
  .route("/enquiry/exam")
  .get(examEnquiryCMS.get_examEnquiry)
  .delete(examEnquiryCMS.del_examEnquiry);

// School Enquiry
adminRouter
  .route("/enquiry/studyindia")
  .get(schoolEnquiryCMS.get_studyindiaEnquiry)

adminRouter
  .route("/enquiry/studyindia/:s_id")
  .get(schoolEnquiryCMS.getStudyIndiaEnquiryDetails)
  .put(schoolEnquiryCMS.update_studyindiaEnquiry)
  .delete(schoolEnquiryCMS.del_studyindiaEnquiry);


  adminRouter
  .route("/enquiry/assignlead")
  .post(schoolEnquiryCMS.assign_leads);

adminRouter
  .route("/enquiry/studyindia/mail/:s_id")
  .post(schoolEnquiryCMS.sendEnquiryMailToStudent);

adminRouter
  .route("/enquiry/studyindia/mails")
  .post(schoolEnquiryCMS.sendBulkEnquiryMailToStudents);

// Student Enquiry
adminRouter
  .route("/enquiry/student")
  .get(studentEnquiryCMS.get_studentEnquiry)
  .put(studentEnquiryCMS.update_studentEnquiry)
  .delete(studentEnquiryCMS.del_studentEnquiry);

adminRouter
  .route("/enquiry/admission/:type")
  .get(studentEnquiryCMS.getAdmissionEnquiry)
  .delete(studentEnquiryCMS.del_AdmissionEnquiry);


  adminRouter
  .route("/enquiry/remark/:us_id")
  // .get(studentEnquiryCMS.update_sc_user_remark)
  // .delete(studentEnquiryCMS.del_AdmissionEnquiry);
  .put(studentEnquiryCMS.update_sc_user_remark)


  // adminRouter
  // .route("/enquiry/admission/partner/:type")
  // .get(studentEnquiryCMS.getPartnerAdmissionEnquiry)
  // // .delete(studentEnquiryCMS.del_AdmissionEnquiry);

// Email group
adminRouter
  .route("/email-group")
  .get(emailTempCMS.emailCategory.getEmailGroup)
  .post(emailTempCMS.emailCategory.createEmailGroup)
  .put(emailTempCMS.emailCategory.updateEmailGroup)
  .delete(emailTempCMS.emailCategory.deleteEmailGroup);

// Email Action Group
adminRouter
  .route("/email-action")
  .get(emailTempCMS.emailAction.getEmailAction)
  .post(emailTempCMS.emailAction.createEmailAction)
  .put(emailTempCMS.emailAction.updateEmailAction)
  .delete(emailTempCMS.emailAction.deleteEmailAction);

// Email Template
adminRouter
  .route("/email-template")
  .get(emailTempCMS.emailTemplate.getEmailTemplate)
  .post(emailTempCMS.emailTemplate.createEmailTemplate)
  .put(emailTempCMS.emailTemplate.updateEmailTemplate)
  .delete(emailTempCMS.emailTemplate.deleteEmailTemplate);

adminRouter
  .route("/template")
  .get(emailTempCMS.sendTemplate.sendTemplateSection);

// SEND EMAIL
adminRouter.route("/test-email").get(emailTempCMS.sendEmail.testemail);
adminRouter.route("/send-email").post(emailTempCMS.sendEmail.sendMailToUser);
adminRouter
  .route("/send-custom-email")
  .post(emailTempCMS.sendEmail.sendCustomizedMailToUsers);

// BECOME A SCHOOL PARNTER
adminRouter
  .route("/become-partner")
  .get(schoolPartnerCMS.getAllBuyers)
  .post(schoolPartnerCMS.addSchoolPartner)
  .put(schoolPartnerCMS.updateSchoolPartner);

// GET SCHOOL PARTNER BY ID
adminRouter
  .route("/become-partner/:id")
  .get(schoolPartnerCMS.getSchoolPartnerById);

// ADD EXISTING SCHOOL BUYER TO SCHOOL PARTNER
adminRouter
  .route("/become-partner-add")
  .put(schoolPartnerCMS.addExistingBuyerToSchoolPartner);


  ////// Partner dashboard enquiry /////

  // adminRouter
  // .route("/enquiry/studyindia-partner")
  // .get(schoolEnquiryCMS.get_studyindiaEnquiry_partner)


  adminRouter
  .route("/users")
  .get(Users.getUsers)
  .post(Users.addUser)
  .put(Users.updateupdateUser);

  adminRouter
  .route("/users/:id")
  .get(Users.getUsers)

  adminRouter
  .route("/users/college/partner")
  .get(Users.getpartnercollege)
  // .post(schoolPartnerCMS.addSchoolPartner)
  // .put(schoolPartnerCMS.updateSchoolPartner);



// UPLOAD FILES TO S3
adminRouter
  .route("/upload-file")
  .post(upload.single("file"), uploadFilesToS3Bucket)
  .delete(deleteFilesFromS3Bucket);

module.exports = adminRouter;