const express = require("express");
const buyerRouter = express.Router();
const buyerDetails = require("../controllers/buyer");
const {
  upload,
  uploadFilesToS3Bucket,
  deleteFilesFromS3Bucket,
} = require("../aws/uploadFiles.aws");

const [
  buyerHome,
  buyerInstitute,
  buyerAwards,
  buyerGenEnq,
  buyerExportEnq,
  buyerAdmEnq,
  buyerFeesDetails,
  buyerFaqDetails,
  
] = [
  buyerDetails.buyerDashboardDetails,
  buyerDetails.buyerInstituteDetails,
  buyerDetails.buyerAwardDetails,
  buyerDetails.buyerGeneralEnquiryDetails,
  buyerDetails.buyerExportDataDetails,
  buyerDetails.buyerAdmissionEnquiryDetails,
  buyerDetails.buyerSchoolFeesDetails,
  buyerDetails.buyerFaqDetails,
  
];

// Buyer Home details
buyerRouter.route("/home").get(buyerHome.getDashboardDetails);


// Buyer Institute
buyerRouter.route("/institute").get(buyerInstitute.getBuyerInstitutes);

// Buyer Institute details
buyerRouter
  .route("/institute-details/:sid")
  .get(buyerInstitute.getBuyerInstituteDetails)
  .put(buyerInstitute.updateBuyerInstituteDetails);

// Buyer Award details
buyerRouter
  .route("/awards/:sid")
  .get(buyerAwards.getBuyerAwards)
  .post(buyerAwards.addBuyerAward)
  .put(buyerAwards.updateBuyerAward)
  .delete(buyerAwards.deleteBuyerAward);

// Buyer General Enquiry details
buyerRouter
  .route("/general-enquiry/:sid")
  .get(buyerGenEnq.getBuyerGeneralEnquiry)
  .put(buyerGenEnq.updateBuyerGeneralEnquiry);

// Buyer Admission Enquiry details
buyerRouter
  .route("/admission-enquiry/:sid")
  .get(buyerAdmEnq.getBuyerAdmissionEnquiry)
  .put(buyerAdmEnq.updateBuyerAdmissionEnquiry);

// Buyer Export Data details
buyerRouter
  .route("/export-enquiry/:sid")
  .get(buyerExportEnq.getStudentEnquiryDataExcel);

// Buyer School Fees details
buyerRouter
  .route("/grade-fee/:sid")
  .get(buyerFeesDetails.getBuyerSchoolFeesDetails)
  .post(buyerFeesDetails.addBuyerSchoolFeesDetails);

// Buyer Faq details
buyerRouter
  .route("/faqs/:sid")
  .get(buyerFaqDetails.getBuyerFaqs)
  .post(buyerFaqDetails.addBuyerFaq)

buyerRouter
  .route("/faq/:sid/:id")
  .get(buyerFaqDetails.getBuyerFaqById)
  .put(buyerFaqDetails.updateBuyerFaqById)
  .delete(buyerFaqDetails.deleteBuyerFaqById)


   
  

// UPLOAD FILES TO S3
buyerRouter
  .route("/upload-file")
  .post(upload.single("file"), uploadFilesToS3Bucket)
  .delete(deleteFilesFromS3Bucket);

module.exports = buyerRouter;
