const express = require("express");
const openRouter = express.Router();
const enqCnt = require("../controllers/public_/Enquiry_");
const eduTypeCnt = require("../controllers/public_/MultipleTblCnt_/educationChoice.controller");
const locTypeCnt = require("../controllers/public_/MultipleTblCnt_/locationChoice.controller");
const smsOtpVerification = require("../controllers/student/Login/otp");
const forgotPassword = require("../controllers/student/Login/forgotPswd");
const studentSignIn = require("../controllers/student/Login/signIn");
const studentSignUp = require("../controllers/student/Login/signup");
const adminLogin = require("../controllers/admin/login");
const buyerLogin = require("../controllers/buyer/Login/login.controller");
const [buyerController, careerController, schoolController, examController,freecounsellController,contactController,ExistingUserEnq] = [
  enqCnt.buyerController,
  enqCnt.careerController,
  enqCnt.schoolController,
  enqCnt.examController,
  enqCnt.freecounsellController,
  enqCnt.contactController,
  enqCnt.ExistingUserEnq,
];
const scDetailsCnt = require("../controllers/public_/Sc_intstitutesDetails/index");
const schoolSignup = require("../controllers/student/Login/schoolSignup");


// GET ALL EDUCATION TYPE OPEN TO EVERYONE--------------------------------------------
openRouter.route("/education-type").get(eduTypeCnt.get_educationCourse);

openRouter.route("/dropdown-career-list").get(eduTypeCnt.get_careerlistfordropdown);




// GET ALL LOCATION TYPE OPEN TO EVERYONE--------------------------------------------
openRouter.route("/location-type/:loc").get(locTypeCnt.get_locationDetails);

// POSTING ENQUIRY/QUIRY OPEN TO EVERYONE--------------------------------------------


// POST Enquiry from GET FREE COUNSELLING BY SHANI
openRouter
  .route("/enquiry/get-free-counselling")
  .get(freecounsellController.get_freecounsell)
  .post(freecounsellController.post_freecounsell);


  openRouter
  .route("/enquiry/get-existing-user-enq")
  .get(ExistingUserEnq.get_existing_enq)
  // .post(freecounsellController.post_freecounsell);

// POST Enquiry from landing page
openRouter
  .route("/enquiry/partner-enquiry")
  .post(buyerController.post_partnerEnquiry);

// POST Enquiry from Career
openRouter
  .route("/enquiry/career-enquiry")
  .post(careerController.post_freelyEnquiry);

// POST Enquiry Foooter
openRouter
  .route("/enquiry/footer-enquiry")
  .post(careerController.post_footerEnquiry);

// POST Enquiry from School
openRouter
  .route("/enquiry/studyindia")
  .post(schoolController.post_studyindiaEnquiry);

// POST Enquiry from Exam
openRouter.route("/enquiry/exam-enquiry").post(examController.post_examEnquiry);

// POST SMS OTP
openRouter.route("/otp").post(smsOtpVerification.getOtpForVerification);
openRouter.route("/otp/verify").post(smsOtpVerification.verifyOtp);

// POST FORGOT STUDENT PASSWORD
openRouter.route("/forgot-password").post(forgotPassword.forgotPass);

// POST STUDENT SIGN IN
openRouter.route("/student-login").post(studentSignIn.student_login);

// POST STUDENT SIGN UP
openRouter.route("/student-signup").post(studentSignUp.signup);

// College Landing Page Signup Created by shani
openRouter.route("/student-signup-lp").post(studentSignUp.landingpagesignup);

// ADMIN LOGIN
openRouter.route("/admin-login").post(adminLogin.admin_login);

// BUYER LOGIN
openRouter.route("/buyer-login").post(buyerLogin.postBuyerLogin);

// SCHOOL SIGNUP
openRouter.route("/school-signup").post(schoolSignup.signupForSchoolStudents);

// GET COLLEGE/SCHOOL DETAILS
openRouter.route("/sc-courses/:id").get(scDetailsCnt.getCollegeCourses);
openRouter.route("/school-names").get(scDetailsCnt.getSchoolNames);

openRouter
  .route("/contactus")
  .post(contactController.post_contactEnq);



module.exports = openRouter;

