const express = require("express");
const publicRouter = express.Router();
const {
  getCollegeDetailsForPublic,
} = require("../controllers/public_/College/college_details.controller");
const {
  getSchoolDetailsForPublic,
} = require("../controllers/public_/School/school_details.controller");

const {
  getSchoolCompareDetailsForPublic,
} = require("../controllers/public_/School/school_compare_controller");

const { getCollegesListingForPublic, getCollegesSearchForPublic } = require("../controllers/public_/College/college_listing.controller");
const { getSchoolsListingForPublic, getSchoolsSearchForPublic } = require("../controllers/public_/School/school_listing.controller");
const { getRecommendedCollegesLandingPage } = require("../controllers/public_/LandingPage/recommended.controller");
const { getRecommendedSchools } = require("../controllers/public_/LandingPage/top_schools.controller");
const { getArticles } = require("../controllers/public_/LandingPage/articles.controller");
const { getExamsForListing, getExamsSearch } = require("../controllers/public_/Exams/exam_listing.controller");
const { getExamDetailsForPublic } = require("../controllers/public_/Exams/exam_details.controller");
const { getCollegesForListing } = require("../controllers/public_/College/colleges_listing.controller");
const { getTopRecommendedColleges } = require("../controllers/public_/TopCommonCollege/top_common_colleges.controller");
const { getAllPartnerColleges } = require("../controllers/public_/TopCommonCollege/top_common_colleges.controller");
const { getCareerOpportunities, getOneCareerDetails, getCareerCategory, getCareerSearchForPublic } = require("../controllers/public_/Career/career_page.controller");
const { getArticlesPage, getOneArticleDetails, getRelatedArticles, getArticlesCategory } = require("../controllers/public_/Article/article_page.controller");
const { getRecommendedColleges } = require("../controllers/public_/College/college_details.controller");
const serverCache = require("../middlewares/CacheRoute.middleware");


//  const { GetCustomLandingPageContent } = require("../controllers/public_/CustomLandingPage/college/clp.controller");
const { GetCustomLandingPageContent } = require("../controllers/public_/CustomLandingPage/college/clp.controller");


  const { GetCustomLandingPageContentSchool } = require("../controllers/public_/CustomLandingPage/school/slp.controller");



publicRouter.route("/college").get(serverCache(500), getCollegeDetailsForPublic);
publicRouter.route("/school").get(serverCache(500), getSchoolDetailsForPublic);

// Listing
publicRouter.route("/colleges/:url").get(serverCache(500), getCollegesListingForPublic);
publicRouter.route("/colleges/:url/:course").get(serverCache(500), getCollegesListingForPublic);
publicRouter.route("/recommended-colleges").get(serverCache(500), getRecommendedColleges);


publicRouter.route("/lp/:url").get(serverCache(500), GetCustomLandingPageContent);


publicRouter.route("/lps/:url").get(serverCache(500), GetCustomLandingPageContentSchool);

publicRouter.route("/schools/:url").get(serverCache(500), getSchoolsListingForPublic);
publicRouter.route("/find/schools").get(serverCache(500), getSchoolsSearchForPublic);

// Get general listing
// publicRouter.route("/colleges").get(serverCache(500), getCollegesListingForPublic);
publicRouter.route("/colleges").get(serverCache(500), getCollegesForListing);
publicRouter.route("/find/colleges").get(serverCache(500), getCollegesSearchForPublic);


// Landing page
publicRouter.route("/landing-page/recommended-colleges/:course").get(serverCache(500), getRecommendedCollegesLandingPage);
publicRouter.route("/landing-page/recommended-schools").get(serverCache(500), getRecommendedSchools)
publicRouter.route("/landing-page/articles").get(serverCache(500), getArticles);

// Exams
publicRouter.route("/exams").get(serverCache(500), getExamsForListing);
publicRouter.route("/exam/:examUrl").get(serverCache(500), getExamDetailsForPublic);
publicRouter.route("/find/exams").get(serverCache(500), getExamsSearch);

// Top common colleges
publicRouter.route("/recommend-top-colleges").get(serverCache(500), getTopRecommendedColleges);
publicRouter.route("/partner-colleges").get(serverCache(500), getAllPartnerColleges);

// Career 
publicRouter.route("/career-opportunities").get(serverCache(500), getCareerOpportunities);
publicRouter.route("/career-opportunity/:url").get(serverCache(500), getOneCareerDetails);
publicRouter.route("/career-opportunities/category").get(serverCache(500), getCareerCategory);
publicRouter.route("/find/courses").get(serverCache(500), getCareerSearchForPublic);

// Articles
publicRouter.route("/articles").get(serverCache(500), getArticlesPage);
publicRouter.route("/article/:url").get(serverCache(500), getOneArticleDetails);
publicRouter.route("/articles-related").get(serverCache(500), getRelatedArticles);
publicRouter.route("/articles-category").get(serverCache(500), getArticlesCategory);



publicRouter.route("/compare-schools").get(serverCache(500), getSchoolCompareDetailsForPublic);


//COntact



module.exports = publicRouter;
