const express = require("express");
const studentRouter = express.Router();
const studentController = require("../controllers/student/index");
const {
  upload,
  uploadFilesToS3Bucket,
  deleteFilesFromS3Bucket,
} = require("../aws/uploadFiles.aws");
const { paymentSuccess } = require("../controllers/payment/razorpayment.controller");

const [
  stdEnquiry,
  stdShortlist,
  stdProfile,
  stdPassword,
  stdReview,
  stdBank,
  stdClgDoc,
  signup,
  appForm,
  commonAppForm,
  manageChild,
  childCAF,
  recommendedSchools,
  clgDashboard,
  leadDetails,
  clgPaymentInfo,
  schoolDashboard,
  schoolMyCart,
] = [
  studentController.studentEnquiry,
  studentController.studentShortlist,
  studentController.studentProfile,
  studentController.studentPassword,
  studentController.collegeReview,
  studentController.bankDetail,
  studentController.uploadDocClg,
  studentController.signup,
  studentController.applicationForm,
  studentController.commonApplicationForm,
  studentController.manageChild,
  studentController.childCommonApplicationForm,
  studentController.recommendedSchools,
  studentController.clgDashboard,
  studentController.leadBasicInfo,
  studentController.collegePaymentInfo,
  studentController.schoolDashboard,
  studentController.leadMyCart,
]; 

// Student Dashboard Enquiry-------------------------------
studentRouter
  .route("/enquiry")
  .get(stdEnquiry.get_studentEnquiry)
  .post(stdEnquiry.post_studentEnquiry);

// Student Shortlist---------------------------------------
studentRouter
  .route("/shortlist")
  .get(stdShortlist.get_studentShortlist)
  .post(stdShortlist.post_studentShortlist)
  .delete(stdShortlist.delete_studentShortlist);

// Student Profile-----------------------------------------
studentRouter
  .route("/profile")
  .get(stdProfile.get_studentProfile)
  .put(stdProfile.update_studentProfile);

// Student Password----------------------------------------
studentRouter.route("/password").put(stdPassword.update_studentPassword);

// Student College/School Review---------------------------
studentRouter
  .route("/review")
  .get(stdReview.get_studentCollegeReview)
  .post(stdReview.post_studentCollegeReview);

// Student Bank Detail-------------------------------------
studentRouter
  .route("/bank-detail")
  .get(stdBank.get_studentBankDetail)
  .post(stdBank.post_studentBankDetail)
  .put(stdBank.update_studentBankDetail)
  .delete(stdBank.delete_studentBankDetail);

// Student Upload Documents College------------------------
studentRouter
  .route("/college-doc")
  .get(stdClgDoc.getCollegeStdDoc)
  .post(stdClgDoc.postCollegeStdDoc)
  .put(stdClgDoc.updateCollegeStdDoc)
  .delete(stdClgDoc.deleteCollegeStdDoc);

// Student Application Form--------------------------------
studentRouter
  .route("/application-form")
  .get(appForm.get_studentApplicationForm)
  .put(appForm.update_studentApplicationForm);

// Student Dashboard--------------------------------------
studentRouter
  .route("/dashboard")
  .get(clgDashboard.getClgDashboardDetails)

// Student Common Application Form-------------------------
studentRouter
  .route("/shortlist-form/:id") // common Form Id
  .get(commonAppForm.getStudentShortlistForm)
  .put(commonAppForm.putStudentShortlistForm);

// Student Payment Info------------------------------------
studentRouter
  .route("/institute-payment")
  .get(clgPaymentInfo.getInstitutePayment)

// School Manage Child------------------------------------
studentRouter
  .route("/manage-child")
  .get(manageChild.get_manageChild)
  .post(manageChild.post_manageChild)
  .put(manageChild.update_manageChild)
  .delete(manageChild.delete_manageChild);

// School Common Application Form--------------------------
studentRouter
  .route("/child-common-form/:id") // id = child_id
  .get(childCAF.get_childCommonApplicationForm)
  .put(childCAF.put_childCommonApplicationForm);

// School Recommended Schools------------------------------
studentRouter
  .route("/partner-schools")
  .get(recommendedSchools.getParnetSchool);

// Get Basic Lead Details----------------------------------
studentRouter
  .route("/lead-details")
  .get(leadDetails.getLeadBasicInfo)

// School Dashboard----------------------------------------
studentRouter
  .route("/school-dashboard")
  .get(schoolDashboard.getSchoolDashboard)

// School My Cart------------------------------------------
studentRouter
  .route("/my-cart")
  .get(schoolMyCart.getSchoolFromCart)
  .post(schoolMyCart.addSchoolToCart)
  .delete(schoolMyCart.deleteSchoolFromCart);

// Student payment
studentRouter
  .route("/payment-success")
  .post(paymentSuccess);

// UPLOAD FILES TO S3
studentRouter
  .route("/upload-file")
  .post(upload.single("file"), uploadFilesToS3Bucket)
  .delete(deleteFilesFromS3Bucket);


module.exports = studentRouter;
