const roleRouteMapper = require("./routesRoles")

const hasRouteAccess = (routeMethod, route, role) => {
  //FOR NOW role = ADMIN
  if (!route || route === "") {
    return {
      status: 500,
      code: "INTERNAL SERVER ERROR",
      routeAccess: false,
      message: "Invalid route.",
    };
  }

  if (!role || role === "") {
    return {
      status: 500,
      code: "INTERNAL SERVER ERROR",
      routeAccess: false,
      message: "Invalid role.",
    };
  }

  route = `${routeMethod}::${route}`;

  if (!roleRouteMapper[route]) {
    return {
      status: 400,
      code: "BAD REQUEST",
      routeAccess: false,
      message: `Route doesn't exist.`,
    };
  }

  const allowedRoles = roleRouteMapper[route];
  const foundRole = allowedRoles.find((currRole) => role === currRole);
  if (!foundRole) {
    return {
      status: 403,
      code: "FORBIDDEN REQUEST",
      routeAccess: false,
      message: "You don't have permission to access the route.",
    };
  }

  return {
    status: 200,
    code: "OK",
    routeAccess: true,
    message: "Ok",
  };
};

module.exports = {
  hasRouteAccess,
};
