const {
  ADMIN,
  SCL_STUDENT,
  CLG_STUDENT,
  BUYER,
} = require("../common/constants");

const roleRouteMapper = {
  // -----------------MASTER-----------------------------

  "GET::/admin/location/*": [ADMIN],

  "GET::/admin/category": [ADMIN],
  "POST::/admin/category": [ADMIN],
  "PUT::/admin/category": [ADMIN],
  "DELETE::/admin/category": [ADMIN],

  "GET::/admin/schooltype": [ADMIN],
  "POST::/admin/schooltype": [ADMIN],
  "PUT::/admin/schooltype": [ADMIN],
  "DELETE::/admin/schooltype": [ADMIN],

  "GET::/admin/collegetype": [ADMIN],
  "POST::/admin/collegetype": [ADMIN],
  "PUT::/admin/collegetype": [ADMIN],
  "DELETE::/admin/collegetype": [ADMIN],

  "GET::/admin/schoolfacility": [ADMIN],
  "POST::/admin/schoolfacility": [ADMIN],
  "PUT::/admin/schoolfacility": [ADMIN],
  "DELETE::/admin/schoolfacility": [ADMIN],

  "GET::/admin/course-level": [ADMIN],
  "POST::/admin/course-level": [ADMIN],
  "PUT::/admin/course-level": [ADMIN],
  "DELETE::/admin/course-level": [ADMIN],

  "GET::/admin/cost-of-study": [ADMIN],
  "POST::/admin/cost-of-study": [ADMIN],
  "PUT::/admin/cost-of-study": [ADMIN],
  "DELETE::/admin/cost-of-study": [ADMIN],

  "GET::/admin/course-delivery": [ADMIN],
  "POST::/admin/course-delivery": [ADMIN],
  "PUT::/admin/course-delivery": [ADMIN],
  "DELETE::/admin/course-delivery": [ADMIN],

  "GET::/admin/company-placement": [ADMIN],
  "POST::/admin/company-placement": [ADMIN],
  "PUT::/admin/company-placement": [ADMIN],
  "DELETE::/admin/company-placement": [ADMIN],

  "GET::/admin/course": [ADMIN],
  "POST::/admin/course": [ADMIN],
  "PUT::/admin/course": [ADMIN],
  "DELETE::/admin/course": [ADMIN],

  "GET::/admin/sc-facilities": [ADMIN],
  "POST::/admin/sc-facilities": [ADMIN],
  "PUT::/admin/sc-facilities": [ADMIN],
  "DELETE::/admin/sc-facilities": [ADMIN],

  "GET::/admin/specialization": [ADMIN],
  "POST::/admin/specialization": [ADMIN],
  "PUT::/admin/specialization": [ADMIN],
  "DELETE::/admin/specialization": [ADMIN],

  "GET::/admin/exam-level": [ADMIN],
  "POST::/admin/exam-level": [ADMIN],
  "PUT::/admin/exam-level": [ADMIN],
  "DELETE::/admin/exam-level": [ADMIN],

  // -----------------CMS-----------------------------

  "GET::/admin/school-details": [ADMIN],
  "POST::/admin/school-details": [ADMIN],
  "PUT::/admin/school-details": [ADMIN],
  "DELETE::/admin/school-details": [ADMIN],

  "GET::/admin/school-details/*": [ADMIN],
  "PUT::/admin/school-details/*": [ADMIN],
  "DELETE::/admin/school-details/*": [ADMIN],

  "GET::/admin/awards/*" : [ADMIN],
  "POST::/admin/awards/*" : [ADMIN],
  "PUT::/admin/awards/*" : [ADMIN],
  "DELETE::/admin/awards/*" : [ADMIN],

  "GET::/admin/grade-fees/*": [ADMIN],
  "POST::/admin/grade-fees/*": [ADMIN],

  "GET::/admin/school-location": [ADMIN],
  "POST::/admin/school-location": [ADMIN],
  "PUT::/admin/school-location": [ADMIN],
  "DELETE::/admin/school-location": [ADMIN],

  "GET::/admin/school-city": [ADMIN],
  "POST::/admin/school-city": [ADMIN],
  "PUT::/admin/school-city": [ADMIN],
  "DELETE::/admin/school-city": [ADMIN],

  "GET::/admin/exam-list": [ADMIN],
  "POST::/admin/exam-list": [ADMIN],
  "PUT::/admin/exam-list": [ADMIN],
  "DELETE::/admin/exam-list": [ADMIN],

  "GET::/admin/career": [ADMIN],
  "POST::/admin/career": [ADMIN],
  "PUT::/admin/career": [ADMIN],
  "DELETE::/admin/career": [ADMIN],

  "GET::/admin/faq/*": [ADMIN, BUYER],
  "POST::/admin/faq/*": [ADMIN, BUYER],
  "PUT::/admin/faq/*": [ADMIN, BUYER],
  "DELETE::/admin/faq/*": [ADMIN, BUYER],

  "GET::/admin/college-details": [ADMIN],
  "POST::/admin/college-details": [ADMIN],
  // "PUT::/admin/college-details": [ADMIN],
  // "DELETE::/admin/college-details": [ADMIN],

  "GET::/admin/college-details/*": [ADMIN],
  "PUT::/admin/college-details/*": [ADMIN],
  "DELETE::/admin/college-details/*": [ADMIN],

  "GET::/admin/college-media/*": [ADMIN],
  "POST::/admin/college-media/*": [ADMIN],
  "PUT::/admin/college-media/*": [ADMIN],
  "DELETE::/admin/college-media/*": [ADMIN],

  "GET::/admin/college-course/*": [ADMIN],
  "POST::/admin/college-course/*": [ADMIN],
  "PUT::/admin/college-course/*": [ADMIN],
  "DELETE::/admin/college-course/*": [ADMIN],

  "GET::/admin/college-contact/*": [ADMIN],
  "POST::/admin/college-contact/*": [ADMIN],
  "PUT::/admin/college-contact/*": [ADMIN],
  "DELETE::/admin/college-contact/*": [ADMIN],

  "GET::/admin/college-additional/*": [ADMIN],
  // "POST::/admin/college-additional/*": [ADMIN],
  "PUT::/admin/college-additional/*": [ADMIN],
  "DELETE::/admin/college-additional/*": [ADMIN],

  "GET::/admin/college-placement/*": [ADMIN],
  "PUT::/admin/college-placement/*": [ADMIN],

  "GET::/admin/college-city": [ADMIN],
  "POST::/admin/college-city": [ADMIN],
  "PUT::/admin/college-city": [ADMIN],
  "DELETE::/admin/college-city": [ADMIN],

  "GET::/admin/college-content": [ADMIN],
  "POST::/admin/college-content": [ADMIN],
  "PUT::/admin/college-content": [ADMIN],
  "DELETE::/admin/college-content": [ADMIN],

  "GET::/admin/accordion-content": [ADMIN],
  "POST::/admin/accordion-content": [ADMIN],
  "DELETE::/admin/accordion-content": [ADMIN],

  "GET::/admin/article-category": [ADMIN],
  "POST::/admin/article-category": [ADMIN],
  "PUT::/admin/article-category": [ADMIN],
  "DELETE::/admin/article-category": [ADMIN],

  "GET::/admin/articles": [ADMIN],
  "POST::/admin/articles": [ADMIN],
  "PUT::/admin/articles": [ADMIN],
  "DELETE::/admin/articles": [ADMIN],

  "GET::/admin/school-content": [ADMIN],
  "POST::/admin/school-content": [ADMIN],
  "PUT::/admin/school-content": [ADMIN],
  "DELETE::/admin/school-content": [ADMIN],

  "GET::/admin/enquiry/career-footer": [ADMIN],
  "DELETE::/admin/enquiry/career-footer": [ADMIN],

  "GET::/admin/enquiry/career": [ADMIN],

  "GET::/admin/enquiry/career/*": [ADMIN],
  "PUT::/admin/enquiry/career/*": [ADMIN],
  "DELETE::/admin/enquiry/career/*": [ADMIN],

  "POST::/admin/enquiry/career/mails": [ADMIN],

  "GET::/admin/enquiry/partner-enquiry": [ADMIN],
  "DELETE::/admin/enquiry/partner-enquiry": [ADMIN],

  "GET::/admin/enquiry/exam": [ADMIN],
  "DELETE::/admin/enquiry/exam": [ADMIN],

  "GET::/admin/enquiry/studyindia": [ADMIN],

  "GET::/admin/enquiry/studyindia/*": [ADMIN],
  "PUT::/admin/enquiry/studyindia/*": [ADMIN],
  "DELETE::/admin/enquiry/studyindia/*": [ADMIN],

  "POST::/admin/enquiry/studyindia/mail/*": [ADMIN],

  "POST::/admin/enquiry/studyindia/mails": [ADMIN],

  "GET::/admin/enquiry/student": [ADMIN],
  "PUT::/admin/enquiry/student": [ADMIN],
  "DELETE::/admin/enquiry/student": [ADMIN],
  "POST::/admin/enquiry/student": [ADMIN],

  "GET::/admin/enquiry/admission/school": [ADMIN],

  "GET::/admin/email-group": [ADMIN],
  "POST::/admin/email-group": [ADMIN],
  "PUT::/admin/email-group": [ADMIN],
  "DELETE::/admin/email-group": [ADMIN],

  "GET::/admin/email-template": [ADMIN],
  "POST::/admin/email-template": [ADMIN],
  "PUT::/admin/email-template": [ADMIN],
  "DELETE::/admin/email-template": [ADMIN],

  "GET::/admin/email-action": [ADMIN],
  "POST::/admin/email-action": [ADMIN],
  "PUT::/admin/email-action": [ADMIN],
  "DELETE::/admin/email-action": [ADMIN],

  "GET::/admin/template": [ADMIN],

  "POST::/admin/send-email": [ADMIN],
  "POST::/admin/send-custom-email": [ADMIN],

  "POST::/admin/upload-file": [ADMIN],
  "DELETE::/admin/upload-file": [ADMIN],

  // -----------------STUDENT-----------------------------

  "POST::/student/login": [SCL_STUDENT, CLG_STUDENT],

  "GET::/student/dashboard": [SCL_STUDENT, CLG_STUDENT],

  "GET::/student/enquiry": [SCL_STUDENT, CLG_STUDENT],
  "POST::/student/enquiry": [SCL_STUDENT, CLG_STUDENT],

  "GET::/student/shortlist": [CLG_STUDENT, SCL_STUDENT],
  "POST::/student/shortlist": [CLG_STUDENT, SCL_STUDENT],
  "DELETE::/student/shortlist": [CLG_STUDENT],

  "GET::/student/profile": [CLG_STUDENT, SCL_STUDENT],
  "PUT::/student/profile": [CLG_STUDENT, SCL_STUDENT],

  "PUT::/student/password": [SCL_STUDENT, CLG_STUDENT],

  "GET::/student/review": [SCL_STUDENT, CLG_STUDENT],
  "POST::/student/review": [SCL_STUDENT, CLG_STUDENT],

  "GET::/student/bank-detail": [CLG_STUDENT],
  "POST::/student/bank-detail": [CLG_STUDENT],
  "PUT::/student/bank-detail": [CLG_STUDENT],
  "DELETE::/student/bank-detail": [CLG_STUDENT],

  "GET::/student/college-doc": [SCL_STUDENT, CLG_STUDENT],
  "POST::/student/college-doc": [SCL_STUDENT, CLG_STUDENT],
  "PUT::/student/college-doc": [SCL_STUDENT, CLG_STUDENT],
  "DELETE::/student/college-doc": [SCL_STUDENT, CLG_STUDENT],

  "GET::/student/application-form": [SCL_STUDENT, CLG_STUDENT],
  "PUT::/student/application-form": [SCL_STUDENT, CLG_STUDENT],

  "GET::/student/shortlist-form/*": [CLG_STUDENT],
  "PUT::/student/shortlist-form/*": [CLG_STUDENT],

  "GET::/student/institute-payment": [SCL_STUDENT, CLG_STUDENT],

  "GET::/student/manage-child": [SCL_STUDENT],
  "POST::/student/manage-child": [SCL_STUDENT],
  "PUT::/student/manage-child": [SCL_STUDENT],
  "DELETE::/student/manage-child": [SCL_STUDENT],

  "GET::/student/child-common-form/*": [SCL_STUDENT],
  "PUT::/student/child-common-form/*": [SCL_STUDENT],

  "GET::/student/partner-schools": [SCL_STUDENT],

  "GET::/student/school-dashboard": [SCL_STUDENT],

  "GET::/student/my-cart": [SCL_STUDENT],
  "POST::/student/my-cart": [SCL_STUDENT],
  "DELETE::/student/my-cart": [SCL_STUDENT],

  "POST::/student/upload-file": [SCL_STUDENT, CLG_STUDENT],
  "DELETE::/student/upload-file": [SCL_STUDENT, CLG_STUDENT],

  "POST::/student/payment-success": [SCL_STUDENT, CLG_STUDENT],

  // -----------------PAYMENT-----------------------------

  "POST::/payment/order": [SCL_STUDENT, CLG_STUDENT],

  // -----------------BUYER-----------------------------

  "GET::/buyer/home": [BUYER],

  "GET::/buyer/institute": [BUYER],

  "GET::/buyer/institute-details/*": [BUYER],
  "PUT::/buyer/institute-details/*": [BUYER],

  "GET::/buyer/awards/*": [BUYER],
  "POST::/buyer/awards/*": [BUYER],
  "PUT::/buyer/awards/*": [BUYER],
  "DELETE::/buyer/awards/*": [BUYER],

  "GET::/buyer/general-enquiry/*": [BUYER],
  "PUT::/buyer/general-enquiry/*": [BUYER],

  "GET::/buyer/admission-enquiry/*": [BUYER],
  "PUT::/buyer/admission-enquiry/*": [BUYER],

  "GET::/buyer/export-enquiry/*": [BUYER],

  "GET::/buyer/grade-fee/*": [BUYER],
  "POST::/buyer/grade-fee/*": [BUYER],

  "POST::/buyer/upload-file": [BUYER],
  "DELETE::/buyer/upload-file": [BUYER],

  "GET::/buyer/faqs/*": [BUYER],
  "POST::/buyer/faqs/*": [BUYER],

  "GET::/buyer/faq/*/*": [BUYER],
  "PUT::/buyer/faq/*/*": [BUYER],
  "DELETE::/buyer/faq/*/*": [BUYER],

  // -----------------SC DETAILS-----------------------------

  "GET::/open/sc-courses/*":[ADMIN, SCL_STUDENT, CLG_STUDENT],
  "GET::/open/school-names":[ADMIN, SCL_STUDENT, CLG_STUDENT],


  // -----------------LEAD BASIC INFO-----------------------------
  "GET::/student/lead-details": [SCL_STUDENT, CLG_STUDENT, BUYER],

  // -----------------BECOME A PARTNER-----------------------------
  "POST::/admin/become-partner": [ADMIN],
  "GET::/admin/become-partner": [ADMIN],
  "PUT::/admin/become-partner":[ADMIN],

  "GET::/admin/become-partner/*": [ADMIN],

  "PUT::/admin/become-partner-add": [ADMIN],

};

module.exports = roleRouteMapper;
