const express = require("express");
 const dotenv = require("dotenv").config({
    path: `.env.${process.env.NODE_ENV}`,
  });
const app = express();
const cors = require("cors");
app.use(cors());
var bodyParser  = require('body-parser');
app.use(bodyParser.json());

app.use(express.static("public"));
const uuid = require("short-uuid");

const fileUpload = require("express-fileupload");
app.use(fileUpload());

const port = 8080;
const publicRouter = require("./routes/Public.routes");
const adminRouter = require("./routes/Admin.routes");
const openRouter = require("./routes/Open.routes");
const studentRouter = require("./routes/Student.routes");
const buyerRouter = require("./routes/Buyer.routes");

// const openRouter = require("./routes/Open.routes");
// const studentRouter = require("./routes/Student.routes");
// const paymentRouter = require("./routes/Payments.route");
// const buyerRouter = require("./routes/Buyer.routes");
// const { connectDB } = require("./config/db.config");
// const { errorHandler } = require("./middlewares/Error.middleware");
// const protect = require("./middlewares/Auth.middleware");
const protectLead = require("./middlewares/Lead.auth.middleware");
const roleRouteAccess = require("./middlewares/RoleAccess.middleware");
// const EventEmitter = require("events");

const serverCache = require("./middlewares/CacheRoute.middleware");
// // Connect to Database
// connectDB();

 


const env = process.env.NODE_ENV;
const allowedOrigins = {
  //  development: "http://localhost:3000",
  development: "https://www.allschoolscolleges.com",
  production: "N/A",
  staging: "*",
};

app.use(
    cors({
      methods: ["GET", "POST", "DELETE", "UPDATE", "PUT", "PATCH", "OPTIONS"],
      origin: allowedOrigins[env],
    })
  );

  app.use(express.json());
  app.use(express.urlencoded({ extended: false }));

 
  
  app.use("/api/v1/admin", adminRouter);
  app.use("/api/v1/public", publicRouter);
  app.use("/api/v1/open", serverCache(300), openRouter);
  app.use("/api/v1/student", protectLead, roleRouteAccess, serverCache(300), studentRouter);

  // app.use("/api/v1/student",studentRouter);
  app.use("/api/v1/buyer", buyerRouter);



app.post("/api/v1/upload", function (req, res) {
  if (req.files && Object.keys(req.files).length !== 0) {
    // Uploaded path
    const uploadedFile = req.files.uploadFile;

    // Logging uploading file


    // Upload path
    let fname = `${uuid.generate()}-${uploadedFile.name}`;
    const uploadPath =
      __dirname +
      "/public/images/" +
      `${req.body.destination ? req.body.destination + "/" : ""}` +
      fname;

    // To save the file using mv() function
    uploadedFile.mv(uploadPath, function (err) {
      if (err) {
        console.log(err);
        res.send("Failed !!");
      } else
        return res.status(200).json({
          message: "File uploaded successfully!",
          access_url: uploadPath,
          file_name: fname,
        });

      // res.send("Successfully Uploaded !!");
    });
  } else res.send("No file uploaded !!");
});
  

  


// const checksum_lib = require("./Paytm/checksum");
// const config = require("./Paytm/config");

//   const parseUrl = express.urlencoded({ extended: false });
//   const parseJson = express.json({ extended: false });

//   app.get("/api/v1/paynow", [parseUrl, parseJson], (req, res) => {
//     // Route for making payment
  

    
//   //   var paymentDetails = {
//   //     amount: req.body.amount,
//   //     customerId: req.body.name.replace(/\s/g,''),
//   //     customerEmail: req.body.email,
//   //     customerPhone: req.body.phone
//   // }


//   var paymentDetails = {
//     amount: '1',
//     customerId:'shani',
//     customerEmail: 'shahj@gmail.com',
//     customerPhone: '7585458585'
// }


//   if(!paymentDetails.amount || !paymentDetails.customerId || !paymentDetails.customerEmail || !paymentDetails.customerPhone) {
//       res.status(400).send('Payment failed')
//   } else {
//       var params = {};
//       params['MID'] = config.PaytmConfig.mid;
//       params['WEBSITE'] = config.PaytmConfig.website;
//       params['CHANNEL_ID'] = 'WEB';
//       params['INDUSTRY_TYPE_ID'] = 'Retail';
//       params['ORDER_ID'] = 'TEST_'  + new Date().getTime();
//       params['CUST_ID'] = paymentDetails.customerId;
//       params['TXN_AMOUNT'] = paymentDetails.amount;
//       params['CALLBACK_URL'] = 'https://api.allschoolscolleges.com/api/v1/callback';
//       params['EMAIL'] = paymentDetails.customerEmail;
//       params['MOBILE_NO'] = paymentDetails.customerPhone;
  
//       console.log("params",params)
  
//       checksum_lib.genchecksum(params, config.PaytmConfig.key, function (err, checksum) {
//         // var txn_url = "https://securegw-stage.paytm.in/order/process"; // for staging
//          var txn_url = "https://securegw.paytm.in/order/process"; // for production
  
//           var form_fields = "";
//           for (var x in params) {
//               form_fields += "<input type='hidden' name='" + x + "' value='" + params[x] + "' >";
//           }
//           form_fields += "<input type='hidden' name='CHECKSUMHASH' value='" + checksum + "' >";
  
//           res.writeHead(200, { 'Content-Type': 'text/html' });
//           res.write('<html><head><title>Merchant Checkout Page</title></head><body><center><h1>Please do not refresh this page...</h1></center><form method="post" action="' + txn_url + '" name="f1">' + form_fields + '</form><script type="text/javascript">document.f1.submit();</script></body></html>');
//           res.end();
//       });
//   }
//   });


//   app.post("/api/v1/callback", (req, res) => {
//     // Route for verifiying payment
  
//     var body = '';
  
//     req.on('data', function (data) {
//        body += data;
//     });
  
//      req.on('end', function () {
//        var html = "";
//        var post_data = qs.parse(body);
  
//        // received params in callback
//        console.log('Callback Response: ', post_data, "\n");
  
  
//        // verify the checksum
//        var checksumhash = post_data.CHECKSUMHASH;
//        // delete post_data.CHECKSUMHASH;
//        var result = checksum_lib.verifychecksum(post_data, config.PaytmConfig.key, checksumhash);
//        console.log("Checksum Result => ", result, "\n");
  
  
//        // Send Server-to-Server request to verify Order Status
//        var params = {"MID": config.PaytmConfig.mid, "ORDERID": post_data.ORDERID};
  
//        checksum_lib.genchecksum(params, config.PaytmConfig.key, function (err, checksum) {
  
//          params.CHECKSUMHASH = checksum;
//          post_data = 'JsonData='+JSON.stringify(params);
  
//          var options = {
//           //  hostname: 'securegw-stage.paytm.in', // for staging
//            hostname: 'securegw.paytm.in', // for production
//            port: 443,
//            path: '/merchant-status/getTxnStatus',
//            method: 'POST',
//            headers: {
//              'Content-Type': 'application/x-www-form-urlencoded',
//              'Content-Length': post_data.length
//            }
//          };
  
  
//          // Set up the request
//          var response = "";
//          var post_req = https.request(options, function(post_res) {
//            post_res.on('data', function (chunk) {
//              response += chunk;
//            });
  
//            post_res.on('end', function(){
//              console.log('S2S Response: ', response, "\n");
  
//              var _result = JSON.parse(response);
//                if(_result.STATUS == 'TXN_SUCCESS') {
//                    res.send('payment sucess')
//                }else {
//                    res.send('payment failed')
//                }
//              });
//          });
  
//          // post the data
//          post_req.write(post_data);
//          post_req.end();
//         });
//        });
//   });
  


app.listen(port, () => {
  console.log(`Listening on port ${port}!`);
});