const { dbQuery, getSqlQuery, getSqlQueryForCount, deleteSqlQuery, updateSqlQuery, addSqlQuery } = require("../config/db.config");
const { SC_ASC_ARTICLES, SC_ARTICLES_CATEGORY } = require("../models/tables");

const getArticlesService = async (queryMap) => {
  try {
    const result = await dbQuery(getSqlQuery(queryMap, SC_ASC_ARTICLES), queryMap.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getArticlesWithPaginationService = async (queryMap) => {
  try {
    const result = await getArticlesService(queryMap);
    if(!result){
      return new Error("No data found");
    }
    const total = await dbQuery(getSqlQueryForCount(queryMap, SC_ASC_ARTICLES), queryMap.parameters);
    return { result, total: total[0].total };
  } catch (error) {
    throw new Error(error);
  }
};

const getArticlesCategoryService = async (queryMap) => {
  try {
    const result = await dbQuery(getSqlQuery(queryMap, SC_ARTICLES_CATEGORY), queryMap.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const addArticlesService = async (queryMap) => {
  try {
    const result = await dbQuery(addSqlQuery(queryMap, SC_ASC_ARTICLES), queryMap.parameters);
    if (!result.affectedRows) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateArticlesService = async (queryMap) => {
  try {
    const result = await dbQuery(updateSqlQuery(queryMap, SC_ASC_ARTICLES), queryMap.parameters);
    if (!result.affectedRows) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteArticleService = async (queryMap) => {
  try {
    const result = await dbQuery(deleteSqlQuery(queryMap, SC_ASC_ARTICLES), queryMap.parameters);
    if (!result.affectedRows) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getArticlesService,
  getArticlesCategoryService,
  getArticlesWithPaginationService,
  deleteArticleService,
  updateArticlesService,
  addArticlesService,
};
