const { dbQuery, getSqlQuery, addSqlQuery, updateSqlQuery, deleteSqlQuery, getSqlQueryForCount } = require("../config/db.config");
const { BUYER_ORDER_DETAILS } = require("../models/tables")

const getBuyerOrderService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, BUYER_ORDER_DETAILS), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const getBuyerOrderPaginationService = async (query) => {
  try {
    const result = await getBuyerOrderService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, BUYER_ORDER_DETAILS), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const addNewBuyerOrderService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, BUYER_ORDER_DETAILS), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateBuyerOrderService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, BUYER_ORDER_DETAILS), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteBuyerOrderService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, BUYER_ORDER_DETAILS), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getBuyerOrderService,
  getBuyerOrderPaginationService,
  addNewBuyerOrderService,
  updateBuyerOrderService,
  deleteBuyerOrderService,
}