const { dbQuery, getSqlQuery, getSqlQueryForCount, deleteSqlQuery, updateSqlQuery, addSqlQuery } = require("../config/db.config");
const { CAREER_LIST } = require("../models/tables");

const getCareerOpportunitiesService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, CAREER_LIST), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getCareerPaginationService = async (query) => {
  try {
    const result = await getCareerOpportunitiesService(query);
    if(result instanceof Error){
      return { result: [], total: 0};
    }
    const total = await dbQuery(getSqlQueryForCount(query, CAREER_LIST), query.parameters);
    return { result, total: total[0].total };
  } catch (error) {
    throw new Error(error);
  }
}

const addCareerService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, CAREER_LIST), query.parameters);
    if (!result.affectedRows) {
      return new Error("No data added");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCareerService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, CAREER_LIST), query.parameters);
    if (!result.affectedRows) {
      return new Error("No data modified");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteCareerService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, CAREER_LIST), query.parameters);
    if (!result.affectedRows) {
      return new Error("No data modified");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getCareerOpportunitiesService,
  getCareerPaginationService,
  deleteCareerService,
  updateCareerService,
  addCareerService,
};
