const { dbQuery, getSqlQuery, addSqlQuery, deleteSqlQuery, updateSqlQuery } = require("../config/db.config");
const { CATEGORY } = require("../models/tables");

const getCategoryService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, CATEGORY), query.parameters);
    if(!result){
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
}

const addNewCategoryService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, CATEGORY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCategoryService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, CATEGORY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteCategoryService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, CATEGORY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getCategoryService,
  addNewCategoryService,
  deleteCategoryService,
  updateCategoryService,
};