const { dbQuery, getSqlQuery, getSqlQueryForCount, addSqlQuery, deleteSqlQuery, updateSqlQuery } = require("../config/db.config");
const {BUYER_ORDER_DETAILS, C_INSTITUTE, C_CONTENT, C_COURSE, C_MEDIA, TBL_AWARDS, TBL_ACCORDION_CONTENT, C_ADDITIONAL,NPF_COURSE_MASTER,TBL_NPF_API,C_CONTACT,PARTNER_STUDENT_DOC } = require("../models/tables");

const getCollegeService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, C_INSTITUTE), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getCollegePaginationService = async (query) => {
  try {
    const result  = await getCollegeService(query);
    if(result instanceof Error){
      return  { result: [], total: 0 }
    }
    const total = await dbQuery(getSqlQueryForCount(query, C_INSTITUTE), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const updateCollegeService = async(query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, C_INSTITUTE), query.parameters);
    if(!result.affectedRows){
      return new Error("Error while updating")
    }
    return result;
  } catch (error) {
    throw new Error(error)
  }
}

const deleteCollegeService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, C_INSTITUTE), query.parameters);
    if (!result.affectedRows) { 
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getCollegesContentService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, C_CONTENT), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getCollegesCourseService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, C_COURSE), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};



const getPayments = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, BUYER_ORDER_DETAILS), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getDocs = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, PARTNER_STUDENT_DOC), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};


 

const getCollegeCoursePaginationService = async (query) => {
  try {
    const result = await getCollegesCourseService(query);
    if(result instanceof Error){
      return { result: [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, C_COURSE), query.parameters);
    return { result, total: total[0].total };
  } catch (error) {
    throw new Error(error)
  }
}

const addNewCollegeCourseService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, C_COURSE), query.parameters);
    if (!result.affectedRows) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCollegeCourseService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, C_COURSE), query.parameters);
    if(!result.affectedRows){
      return new Error("Error while updating")
    }
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const deleteCollegeCourseService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, C_COURSE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data modified");
    }
  return result
  } catch (error) {
    throw new Error(error)
  }
}

const addNewCollegeService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, C_INSTITUTE), query.parameters);
    if (!result.affectedRows) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const addNewCollegeAdditionalDetailsService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, C_ADDITIONAL), query.parameters);
    if (!result.affectedRows) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const addNewCollegecontactDetailsService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, C_CONTACT), query.parameters);
    if (!result.affectedRows) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const addNewCollegeImageService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, C_MEDIA), query.parameters);
    if (!result.affectedRows) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getCollegeAwardService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, TBL_AWARDS), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};


const getnpfCourses = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, NPF_COURSE_MASTER), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};



const getnpfCredentials = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, TBL_NPF_API), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};


const getCollegeFaqService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, TBL_ACCORDION_CONTENT), query.parameters);
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getCollegeService,
  getCollegePaginationService,
  addNewCollegeService,
  addNewCollegeAdditionalDetailsService,
  addNewCollegecontactDetailsService,
  addNewCollegeImageService,
  updateCollegeService,
  deleteCollegeService,
  getCollegesContentService,
  getCollegesCourseService,
  getCollegeAwardService,
  getCollegeFaqService,
  getCollegeCoursePaginationService,
  deleteCollegeCourseService,
  updateCollegeCourseService,
  addNewCollegeCourseService,
  getnpfCourses,
  getnpfCredentials,
  getPayments,
  getDocs
};
