const { dbQuery, getSqlQuery, addSqlQuery, updateSqlQuery, deleteSqlQuery, getSqlQueryForCount } = require("../config/db.config");

const getEnquiryService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, query.table), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const getEnquiryPaginationService = async (query) => {
  try {
    const result = await getEnquiryService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    const total = await dbQuery(getSqlQueryForCount(query, query.table), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const addNewEnquiryService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, query.table), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateEnquiryService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, query.table), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteEnquiryService = async (query) => {
  
  try {
    const result = await dbQuery(deleteSqlQuery(query, query.table), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

 
const deleteAdmissionService = async (query) => {
  //  console.log("query shani",query.parameters)
  try {
    const result = await dbQuery(deleteSqlQuery(query, query.table), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};


module.exports = {
  getEnquiryService,
  getEnquiryPaginationService,
  addNewEnquiryService,
  updateEnquiryService,
  deleteEnquiryService,
  deleteAdmissionService,
}