const { dbQuery, getSqlQuery, getSqlQueryForCount, addSqlQuery, updateSqlQuery, deleteSqlQuery } = require("../config/db.config");
const { TBL_EXAM_COURSE, CATEGORY } = require("../models/tables");

const getExamCategoriesService = async (query) => {
  try {
    const result = await dbQuery(
      getSqlQuery(query, CATEGORY),
      query.parameters
    );
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getExamsByCategoryIdService = async (query) => {
  try {
    const result = await dbQuery(
      getSqlQuery(query, TBL_EXAM_COURSE),
      query.parameters
    );
    if (!result) {
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getExamPaginationService = async (query) => {
  try {
    const result = await getExamsByCategoryIdService(query);
    if(result instanceof Error){
      return { result: [], total: 0};
    }
    const total = await dbQuery(getSqlQueryForCount(query, TBL_EXAM_COURSE), query.parameters);
    return { result, total: total[0].total };
  } catch (error) {
    throw new Error(error);
  }
};

const addExamService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, TBL_EXAM_COURSE), query.parameters);
    if(result.affectedRows === 0){
      return new Error("No data added");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateExamService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, TBL_EXAM_COURSE), query.parameters);
    if(result.affectedRows === 0){
      return new Error("No data modified");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteExamService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, TBL_EXAM_COURSE), query.parameters);
    if(result.affectedRows === 0){
      return new Error("No data modified");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getExamCategoriesService,
  getExamsByCategoryIdService,
  getExamPaginationService,
  deleteExamService,
  addExamService,
  updateExamService,
};
