const { dbQuery, getSqlQuery, addSqlQuery, deleteSqlQuery, updateSqlQuery } = require("../../config/db.config");
const { INSTITUTE_TYPE } = require("../../models/tables");

const getCollegeTypeService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, INSTITUTE_TYPE), query.parameters);
    if(!result){
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
}

const addNewCollegeTypeService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, INSTITUTE_TYPE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCollegeTypeService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, INSTITUTE_TYPE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteCollegeTypeService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, INSTITUTE_TYPE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getCollegeTypeService,
  addNewCollegeTypeService,
  deleteCollegeTypeService,
  updateCollegeTypeService,
};