const { dbQuery, getSqlQuery, getSqlQueryForCount, addSqlQuery, deleteSqlQuery, updateSqlQuery } = require("../../config/db.config");
const { COMPANY_PLACEMENT } = require("../../models/tables");

const getCompanyPlacementService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, COMPANY_PLACEMENT), query.parameters);
    if(!result){
      return new Error("No data found");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const getCompanyPlacementPaginationService = async (query) => {
  try {
    const result = await getCompanyPlacementService(query);
    if(result instanceof Error){
      return { result: [], total: 0 };
    };
    const total = await dbQuery(getSqlQueryForCount(query, COMPANY_PLACEMENT), query.parameters);
    return { result, total: total[0].total };
  } catch (error) {
    throw new Error(error);
  }
}

const addNewCompanyPlacementService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, COMPANY_PLACEMENT), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCompanyPlacementService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, COMPANY_PLACEMENT), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteCompanyPlacementService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, COMPANY_PLACEMENT), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getCompanyPlacementPaginationService,
  addNewCompanyPlacementService,
  deleteCompanyPlacementService,
  updateCompanyPlacementService,
  getCompanyPlacementService,
};