const { dbQuery, getSqlQuery, getSqlQueryForCount, addSqlQuery, deleteSqlQuery, updateSqlQuery } = require("../../config/db.config");
const { COST_OF_STUDY } = require("../../models/tables");

const getCostOfStudyPaginationService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, COST_OF_STUDY), query.parameters);
    if(!result){
      return new Error("No data found");
    }
    const total = await dbQuery(getSqlQueryForCount(query, COST_OF_STUDY), query.parameters);
    return { result, total: total[0].total };
  } catch (error) {
    throw new Error(error);
  }
}

const addNewCostOfStudyService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, COST_OF_STUDY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCostOfStudyService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, COST_OF_STUDY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteCostOfStudyService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, COST_OF_STUDY), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getCostOfStudyPaginationService,
  addNewCostOfStudyService,
  deleteCostOfStudyService,
  updateCostOfStudyService,
};