const { dbQuery, getSqlQuery, addSqlQuery, updateSqlQuery, deleteSqlQuery, getSqlQueryForCount } = require("../../config/db.config");
const { COURSE } = require("../../models/tables");

const getCourseService = async (query) => {
  try {
    const result = await dbQuery(getSqlQuery(query, COURSE), query.parameters);
    if(!result){
      return new Error("No data found");
    };
    return result;
  } catch (error) {
    throw new Error(error)
  }
};

const getCoursePaginationService = async (query) => {
  try {
    const result = await getCourseService(query);
    if(!result){
      return { result : [], total: 0 };
    }
    console.log("getSqlQueryForCount(query, COURSE), query.parameters",getSqlQueryForCount(query, COURSE), query.parameters)
    const total = await dbQuery(getSqlQueryForCount(query, COURSE), query.parameters);
    return { result, total: total[0].total}
  } catch (error) {
    throw new Error(error);
  }
};

const addNewCourseService = async (query) => {
  try {
    const result = await dbQuery(addSqlQuery(query, COURSE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Inserted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const updateCourseService = async (query) => {
  try {
    const result = await dbQuery(updateSqlQuery(query, COURSE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Updated");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

const deleteCourseService = async (query) => {
  try {
    const result = await dbQuery(deleteSqlQuery(query, COURSE), query.parameters);
    if(!result.affectedRows){
      return new Error("No data Deleted");
    }
    return result;
  } catch (error) {
    throw new Error(error);
  }
};

module.exports = {
  getCourseService,
  getCoursePaginationService,
  addNewCourseService,
  updateCourseService,
  deleteCourseService,
}